/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenEncodingWindow
extends JDialog {
    private static final long serialVersionUID = 5496087410697509828L;
    private static final Logger logger = LoggerFactory.getLogger(OpenEncodingWindow.class);
    private final JScrollPane scrollPane = new JScrollPane();
    private JTable table;
    private static String[][] charsets = OpenEncodingWindow.charsets();
    private String inputedCriteria;

    public OpenEncodingWindow() {
        this.setResizable(false);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(OpenEncodingWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.setTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("AboutPopup.this.title"));
        this.setModal(true);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setBounds(100, 100, 475, 500);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JTextPane txtpnByDefaultPuck = new JTextPane();
        txtpnByDefaultPuck.setBackground(new Color(238, 238, 238));
        panelContent.add((Component)txtpnByDefaultPuck, "4, 2");
        txtpnByDefaultPuck.setEditable(false);
        txtpnByDefaultPuck.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("OpenEncodingWindow.txtpnByDefaultPuck.text"));
        this.table = new JTable();
        this.table.setSelectionMode(0);
        this.table.setModel(new DefaultTableModel(charsets, new String[]{"Encoding Code", "Description"}){
            Class[] columnTypes;
            {
                this.columnTypes = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }
        });
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        panelContent.add((Component)this.scrollPane, "4, 5");
        this.scrollPane.setViewportView(this.table);
        JPanel panel_1 = new JPanel();
        this.getContentPane().add((Component)panel_1, "South");
        JButton btnCancel = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("OpenEncodingWindow.btnCancel.text"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenEncodingWindow.this.dispose();
            }
        });
        btnCancel.setActionCommand("OK");
        panel_1.add(btnCancel);
        JButton button = new JButton("OK");
        panel_1.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("OK pressed.");
                int selectedIndex = OpenEncodingWindow.this.table.getSelectedRow();
                if (selectedIndex == -1) {
                    JOptionPane.showMessageDialog(null, "Select one line in table.", "Bad selection", 0);
                } else {
                    OpenEncodingWindow.this.inputedCriteria = charsets[selectedIndex][0];
                    OpenEncodingWindow.this.setVisible(false);
                }
            }
        });
        button.setActionCommand("OK");
    }

    public String getCriteria() {
        String result = this.inputedCriteria;
        return result;
    }

    public static String[][] charsets() {
        String[][] result = new String[][]{{"8859_1", "ISO Latin-1"}, {"8859_2", "ISO Latin-2"}, {"8859_3", "ISO Latin-3"}, {"8859_4", "ISO Latin-4"}, {"8859_5", "ISO Latin/Cyrillic"}, {"8859_6", "ISO Latin/Arabic"}, {"8859_7", "ISO Latin/Greek"}, {"8859_8", "ISO Latin/Hebrew"}, {"8859_9", "ISO Latin-5"}, {"8859_15", "ISO Latin-9"}, {"Big5", "Big 5 Traditional Chinese"}, {"CNS11643", "CNS 11643 Traditional Chinese"}, {"Cp1250", "Windows Eastern Europe / Latin-2"}, {"Cp1251", "Windows Cyrillic"}, {"Cp1252", "Windows Western Europe / Latin-1"}, {"Cp1253", "Windows Greek"}, {"Cp1254", "Windows Turkish"}, {"Cp1255", "Windows Hebrew"}, {"Cp1256", "Windows Arabic"}, {"Cp1257", "Windows Baltic"}, {"Cp1258", "Windows Vietnamese"}, {"Cp437", "PC Original"}, {"Cp737", "PC Greek"}, {"Cp775", "PC Baltic"}, {"Cp850", "PC Latin-1"}, {"Cp852", "PC Latin-2"}, {"Cp855", "PC Cyrillic"}, {"Cp857", "PC Turkish"}, {"Cp860", "PC Portuguese"}, {"Cp861", "PC Icelandic"}, {"Cp862", "PC Hebrew"}, {"Cp863", "PC Canadian French"}, {"Cp864", "PC Arabic"}, {"Cp865", "PC Nordic"}, {"Cp866", "PC Russian"}, {"Cp869", "PC Modern Greek"}, {"Cp874", "Windows Thai"}, {"EUCJIS", "Japanese EUC"}, {"GB2312", "GB2312-80 Simplified Chinese"}, {"JIS", "JIS"}, {"KSC5601", "KSC5601 Korean"}, {"MacArabic", "Macintosh Arabic"}, {"MacCentralEurope", "Macintosh Latin-2"}, {"MacCroatian", "Macintosh Croatian"}, {"MacCyrillic", "Macintosh Cyrillic"}, {"MacDingbat", "Macintosh Dingbat"}, {"MacGreek", "Macintosh Greek"}, {"MacHebrew", "Macintosh Hebrew"}, {"MacIceland", "Macintosh Iceland"}, {"MacRoman", "Macintosh Roman"}, {"MacRomania", "Macintosh Romania"}, {"MacSymbol", "Macintosh Symbol"}, {"MacThai", "Macintosh Thai"}, {"MacTurkish", "Macintosh Turkish"}, {"MacUkraine", "Macintosh Ukraine"}, {"SJIS", "PC and Windows Japanese"}, {"UTF8", "Standard UTF-8"}};
        return result;
    }

    public static String showDialog() {
        OpenEncodingWindow dialog = new OpenEncodingWindow();
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        String result = dialog.getCriteria();
        return result;
    }
}

