/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.workers.ControlReporter;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.FooReporterInputWindow;

public class ControlInputWindow
extends JFrame {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages");
    private static final Logger logger = LoggerFactory.getLogger(ControlInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private JPanel contentPane;
    private JCheckBox chckbxSameSexSpouses;
    private JCheckBox chckbxFemaleFathersOrMaleMothers;
    private JCheckBox chckbxCyclicDescentCases;
    private JCheckBox chckbxUnknownSexPersons;
    private JCheckBox chckbxNamelessPersons;
    private JCheckBox chckbxParentChildMarriages;
    private JCheckBox chckbxMultipleParents;
    private JCheckBox chckbxAutomarriages;
    private JCheckBox chckbxInconsistentDates;
    private JCheckBox chckbxMissingDates;
    private JCheckBox chckbxUnknownSexParentsSpouses;

    public ControlInputWindow(final NetGUI netGUI) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(FooReporterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.setTitle(BUNDLE.getString("ControlReporterInputWindow.this.title"));
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 395, 430);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel inputPanel = new JPanel();
        this.contentPane.add((Component)inputPanel, "Center");
        inputPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        this.chckbxSameSexSpouses = new JCheckBox(BUNDLE.getString("ControlReporterInputWindow.chckbxSameSexSpouses.text"));
        this.chckbxSameSexSpouses.setSelected(true);
        inputPanel.add((Component)this.chckbxSameSexSpouses, "4, 2");
        this.chckbxFemaleFathersOrMaleMothers = new JCheckBox(BUNDLE.getString("ControlReporterInputWndow.chckbxFemalFathersOrMaleMothers"));
        this.chckbxFemaleFathersOrMaleMothers.setSelected(true);
        inputPanel.add((Component)this.chckbxFemaleFathersOrMaleMothers, "4, 4");
        this.chckbxMultipleParents = new JCheckBox(BUNDLE.getString("ControlInputWindow.chckbxMultipleFathersOr.text"));
        this.chckbxMultipleParents.setSelected(true);
        inputPanel.add((Component)this.chckbxMultipleParents, "4, 6");
        this.chckbxCyclicDescentCases = new JCheckBox(BUNDLE.getString("ControlReporterInputWindow.chckbxCyclicDescentCases.text"));
        this.chckbxCyclicDescentCases.setSelected(true);
        inputPanel.add((Component)this.chckbxCyclicDescentCases, "4, 8");
        this.chckbxUnknownSexPersons = new JCheckBox(BUNDLE.getString("ControlReporterInputWindow.chckbxUnknownSexPersons.text"));
        this.chckbxUnknownSexPersons.setSelected(true);
        inputPanel.add((Component)this.chckbxUnknownSexPersons, "4, 10");
        this.chckbxNamelessPersons = new JCheckBox(BUNDLE.getString("ControlReporterInputWindow.chckbxNamelessPersons.text"));
        this.chckbxNamelessPersons.setSelected(true);
        inputPanel.add((Component)this.chckbxNamelessPersons, "4, 14");
        this.chckbxParentChildMarriages = new JCheckBox(BUNDLE.getString("ControlReporterInputWindow.chckbxParentChildMarriages.text"));
        this.chckbxParentChildMarriages.setSelected(true);
        inputPanel.add((Component)this.chckbxParentChildMarriages, "4, 16");
        this.chckbxAutomarriages = new JCheckBox(BUNDLE.getString("ControlInputWindow.chckbxAutomarriages.text"));
        this.chckbxAutomarriages.setSelected(true);
        inputPanel.add((Component)this.chckbxAutomarriages, "4, 18");
        this.chckbxInconsistentDates = new JCheckBox(BUNDLE.getString("ControlInputWindow.chckbxInconsistentDates.text"));
        inputPanel.add((Component)this.chckbxInconsistentDates, "4, 20");
        this.chckbxMissingDates = new JCheckBox(BUNDLE.getString("ControlInputWindow.chckbxMissingDates.text"));
        inputPanel.add((Component)this.chckbxMissingDates, "4, 22");
        this.chckbxUnknownSexParentsSpouses = new JCheckBox(BUNDLE.getString("ControlInputWindow.chckbxSameparentsex.text"));
        this.chckbxUnknownSexParentsSpouses.setSelected(true);
        inputPanel.add((Component)this.chckbxUnknownSexParentsSpouses, "4, 12");
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton(BUNDLE.getString("ControlReporterInputWindow.btnCancel.text"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlInputWindow.this.dispose();
            }
        });
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton(BUNDLE.getString("ControlReporterInputWindow.btnLaunch.text"));
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<ControlReporter.ControlType> controlTypes = new ArrayList<ControlReporter.ControlType>();
                    if (ControlInputWindow.this.chckbxCyclicDescentCases.isSelected()) {
                        controlTypes.add(ControlReporter.ControlType.CYCLIC_DESCENT_CASES);
                    }
                    if (ControlInputWindow.this.chckbxFemaleFathersOrMaleMothers.isSelected()) {
                        controlTypes.add(ControlReporter.ControlType.FEMALE_FATHERS_OR_MALE_MOTHERS);
                    }
                    if (ControlInputWindow.this.chckbxMultipleParents.isSelected()) {
                        controlTypes.add(ControlReporter.ControlType.MULTIPLE_FATHERS_OR_MOTHERS);
                    }
                    if (ControlInputWindow.this.chckbxNamelessPersons.isSelected()) {
                        controlTypes.add(ControlReporter.ControlType.NAMELESS_PERSONS);
                    }
                    if (ControlInputWindow.this.chckbxParentChildMarriages.isSelected()) {
                        controlTypes.add(ControlReporter.ControlType.PARENT_CHILD_MARRIAGES);
                    }
                    if (ControlInputWindow.this.chckbxAutomarriages.isSelected()) {
                        controlTypes.add(ControlReporter.ControlType.AUTO_MARRIAGE);
                    }
                    if (ControlInputWindow.this.chckbxSameSexSpouses.isSelected()) {
                        controlTypes.add(ControlReporter.ControlType.SAME_SEX_SPOUSES);
                    }
                    if (ControlInputWindow.this.chckbxUnknownSexPersons.isSelected()) {
                        controlTypes.add(ControlReporter.ControlType.UNKNOWN_SEX_PERSONS);
                    }
                    if (ControlInputWindow.this.chckbxUnknownSexParentsSpouses.isSelected()) {
                        controlTypes.add(ControlReporter.ControlType.UNKNOWN_SEX_PARENTS_SPOUSES);
                    }
                    if (ControlInputWindow.this.chckbxInconsistentDates.isSelected()) {
                        controlTypes.add(ControlReporter.ControlType.INCONSISTENT_DATES);
                    }
                    if (ControlInputWindow.this.chckbxMissingDates.isSelected()) {
                        controlTypes.add(ControlReporter.ControlType.MISSING_DATES);
                    }
                    ControlReporter.ControlType[] controls = new ControlReporter.ControlType[controlTypes.size()];
                    controlTypes.toArray(controls);
                    Report report = ControlReporter.reportControls(netGUI.getSegmentation(), BUNDLE, controls);
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(ControlInputWindow.this.thisJFrame, message, title, 1);
                    } else {
                        netGUI.addReportTab(report);
                    }
                    ControlInputWindow.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(ControlInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
    }
}

