/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusDetail;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.CensusUtils;
import org.tip.puck.census.workers.ChainValuator;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.census.workers.CircuitType;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.census.workers.SiblingMode;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.graphs.onemode.OMGraph;
import org.tip.puck.graphs.onemode.ShuffleCriteria;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.views.FooReporterInputWindow;

public class CensusInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(CensusInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private NetGUI netGUI;
    private JPanel contentPane;
    private final ButtonGroup buttonGroupSymmetry = new ButtonGroup();
    private final ButtonGroup buttonGroupFiliation = new ButtonGroup();
    private final ButtonGroup buttonGroupSib = new ButtonGroup();
    private final ButtonGroup buttonGroupCircuit = new ButtonGroup();
    private JTextField txtfldPattern;
    private JTextField txtfldFilter;
    private JCheckBox chckbxCrossSex;
    private JCheckBox chckbxMarriedOnly;
    private final ButtonGroup buttonGroupRestriction = new ButtonGroup();
    private JRadioButton rdbtnCircuitTypeCircuit;
    private JRadioButton rdbtnCircuitTypeRing;
    private JRadioButton rdbtnCircuitTypeMinor;
    private JRadioButton rdbtnCircuitTypeMinimal;
    private JRadioButton rdbtnFiliationAgnatic;
    private JRadioButton rdbtnFiliationUterine;
    private JRadioButton rdbtnFiliationCognatic;
    private JRadioButton rdbtnFiliationBilateral;
    private JRadioButton rdbtnRestrictionNone;
    private JRadioButton rdbtnRestrictionSome;
    private JRadioButton rdbtnRestrictionAll;
    private JRadioButton rdbtnRestrictionLastMarried;
    private JRadioButton rdbtnSibNone;
    private JRadioButton rdbtnSibFull;
    private JRadioButton rdbtnSibAll;
    private JRadioButton rdbtnSymmetryInvariable;
    private JRadioButton rdbtnSymmetryInvertible;
    private JRadioButton rdbtnSymmetryPermutable;
    private JLabel lblRelationType;
    private JButton btnRestoreDefaults;
    private JComboBox cmbbxClosingRelationType;
    private JLabel lblChainClassification;
    private JComboBox cmbbxClassification;
    private JComboBox cmbbxClassificatoryLinking;
    private JPanel panel;
    private JLabel lblLabel;
    private JLabel lblReport;
    private JLabel lblDiagram;
    private JComboBox cmbbxLabel1;
    private JCheckBox chckbxReport1;
    private JCheckBox chckbxDiagram1;
    private JComboBox cmbbxLabel2;
    private JComboBox cmbbxLabel3;
    private JComboBox cmbbxLabel4;
    private JComboBox cmbbxLabel5;
    private JCheckBox chckbxReport2;
    private JCheckBox chckbxDiagram2;
    private JCheckBox chckbxReport3;
    private JCheckBox chckbxReport4;
    private JCheckBox chckbxReport5;
    private JCheckBox chckbxDiagram3;
    private JCheckBox chckbxDiagram4;
    private JCheckBox chckbxDiagram5;
    private JComboBox cmbbxLabel6;
    private JComboBox cmbbxLabel7;
    private JComboBox cmbbxLabel8;
    private JComboBox cmbbxLabel9;
    private JComboBox cmbbxLabel10;
    private JCheckBox chckbxReport6;
    private JCheckBox chckbxReport7;
    private JCheckBox chckbxReport8;
    private JCheckBox chckbxReport9;
    private JCheckBox chckbxReport10;
    private JCheckBox chckbxDiagram6;
    private JCheckBox chckbxDiagram7;
    private JCheckBox chckbxDiagram8;
    private JCheckBox chckbxDiagram9;
    private JCheckBox chckbxDiagram10;
    private JLabel label_1;
    private JLabel label_2;
    private JLabel label_3;
    private JSeparator separator;
    private static String[] endogenousLabels;
    private JCheckBox chckbxMarkIndividuals;
    private JPanel panel_2;
    private JCheckBox chckbxCircuitIntersection;
    private JCheckBox chckbxCircuitInduced;
    private JCheckBox chckbxCircuitInducedFrame;
    private JCheckBox chckbxCircuitNetworks;
    private JCheckBox chckbxOpenChainFrequencies;
    private JPanel panel_3;
    private JLabel lblEgoRole;
    private JLabel lblAlterRole;
    private JComboBox cmbbxClosingRelationEgoRole;
    private JComboBox cmbbxClosingRelationAlterRole;
    private JButton btnLaunchWithReshuffling;
    private JCheckBox chckbxCircuitsAsRelations;
    private JCheckBox chckbxListOutofcircuitPairs;
    private JCheckBox chckbxListAllPerspectives;

    public CensusInputWindow(final NetGUI netGUI) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(FooReporterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        if (endogenousLabels == null) {
            endogenousLabels = ChainValuator.getEndogenousLabels();
        }
        this.thisJFrame = this;
        this.netGUI = netGUI;
        this.setTitle("Census Reporter Inputs");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 980, 600);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panelInputs = new JPanel();
        this.contentPane.add((Component)panelInputs, "Center");
        panelInputs.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblPattern = new JLabel("Pattern:");
        panelInputs.add((Component)lblPattern, "4, 2, right, default");
        this.txtfldPattern = new JTextField();
        this.txtfldPattern.setColumns(10);
        panelInputs.add((Component)this.txtfldPattern, "6, 2, fill, default");
        JLabel lblex = new JLabel("(ex. \"3 2 4\" ou \"HF(F)F\")");
        panelInputs.add((Component)lblex, "6, 4");
        this.panel = new JPanel();
        this.panel.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "Details and Diagrams", 4, 2, null, new Color(51, 51, 51)));
        panelInputs.add((Component)this.panel, "10, 2, 1, 7, fill, fill");
        this.panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.lblLabel = new JLabel("Label");
        this.panel.add((Component)this.lblLabel, "2, 2, left, default");
        this.lblReport = new JLabel("Report");
        this.panel.add((Component)this.lblReport, "4, 2, left, default");
        this.lblDiagram = new JLabel("Diagram");
        this.panel.add((Component)this.lblDiagram, "6, 2, left, default");
        this.separator = new JSeparator();
        this.separator.setOrientation(1);
        this.panel.add((Component)this.separator, "8, 2, 1, 11");
        this.label_1 = new JLabel("Label");
        this.panel.add((Component)this.label_1, "10, 2");
        this.label_2 = new JLabel("Report");
        this.panel.add((Component)this.label_2, "12, 2");
        this.label_3 = new JLabel("Diagram");
        this.panel.add((Component)this.label_3, "14, 2");
        this.cmbbxLabel1 = new JComboBox<String>(endogenousLabels);
        this.panel.add((Component)this.cmbbxLabel1, "2, 4, fill, default");
        this.chckbxReport1 = new JCheckBox("");
        this.panel.add((Component)this.chckbxReport1, "4, 4, center, default");
        this.chckbxDiagram1 = new JCheckBox("");
        this.panel.add((Component)this.chckbxDiagram1, "6, 4, center, default");
        this.cmbbxLabel6 = new JComboBox<String>(endogenousLabels);
        this.panel.add((Component)this.cmbbxLabel6, "10, 4, fill, default");
        this.chckbxReport6 = new JCheckBox("");
        this.panel.add((Component)this.chckbxReport6, "12, 4, center, default");
        this.chckbxDiagram6 = new JCheckBox("");
        this.panel.add((Component)this.chckbxDiagram6, "14, 4, center, default");
        this.cmbbxLabel2 = new JComboBox<String>(endogenousLabels);
        this.panel.add((Component)this.cmbbxLabel2, "2, 6, fill, default");
        this.chckbxReport2 = new JCheckBox("");
        this.panel.add((Component)this.chckbxReport2, "4, 6, center, default");
        this.chckbxDiagram2 = new JCheckBox("");
        this.panel.add((Component)this.chckbxDiagram2, "6, 6, center, default");
        this.cmbbxLabel7 = new JComboBox<String>(endogenousLabels);
        this.panel.add((Component)this.cmbbxLabel7, "10, 6, fill, default");
        this.chckbxReport7 = new JCheckBox("");
        this.panel.add((Component)this.chckbxReport7, "12, 6, center, default");
        this.chckbxDiagram7 = new JCheckBox("");
        this.panel.add((Component)this.chckbxDiagram7, "14, 6, center, default");
        this.cmbbxLabel3 = new JComboBox<String>(endogenousLabels);
        this.panel.add((Component)this.cmbbxLabel3, "2, 8, fill, default");
        this.chckbxReport3 = new JCheckBox("");
        this.panel.add((Component)this.chckbxReport3, "4, 8, center, default");
        this.chckbxDiagram3 = new JCheckBox("");
        this.panel.add((Component)this.chckbxDiagram3, "6, 8, center, default");
        this.cmbbxLabel8 = new JComboBox<String>(endogenousLabels);
        this.panel.add((Component)this.cmbbxLabel8, "10, 8, fill, default");
        this.chckbxReport8 = new JCheckBox("");
        this.panel.add((Component)this.chckbxReport8, "12, 8, center, default");
        this.chckbxDiagram8 = new JCheckBox("");
        this.panel.add((Component)this.chckbxDiagram8, "14, 8, center, default");
        this.cmbbxLabel4 = new JComboBox<String>(endogenousLabels);
        this.panel.add((Component)this.cmbbxLabel4, "2, 10, fill, default");
        this.chckbxReport4 = new JCheckBox("");
        this.panel.add((Component)this.chckbxReport4, "4, 10, center, default");
        this.chckbxDiagram4 = new JCheckBox("");
        this.panel.add((Component)this.chckbxDiagram4, "6, 10, center, default");
        this.cmbbxLabel9 = new JComboBox<String>(endogenousLabels);
        this.panel.add((Component)this.cmbbxLabel9, "10, 10, fill, default");
        this.chckbxReport9 = new JCheckBox("");
        this.panel.add((Component)this.chckbxReport9, "12, 10, center, default");
        this.chckbxDiagram9 = new JCheckBox("");
        this.panel.add((Component)this.chckbxDiagram9, "14, 10, center, default");
        this.cmbbxLabel5 = new JComboBox<String>(endogenousLabels);
        this.panel.add((Component)this.cmbbxLabel5, "2, 12, fill, default");
        this.chckbxReport5 = new JCheckBox("");
        this.panel.add((Component)this.chckbxReport5, "4, 12, center, default");
        this.chckbxDiagram5 = new JCheckBox("");
        this.panel.add((Component)this.chckbxDiagram5, "6, 12, center, default");
        this.cmbbxLabel10 = new JComboBox<String>(endogenousLabels);
        this.panel.add((Component)this.cmbbxLabel10, "10, 12, fill, default");
        this.chckbxReport10 = new JCheckBox("");
        this.panel.add((Component)this.chckbxReport10, "12, 12, center, default");
        this.chckbxDiagram10 = new JCheckBox("");
        this.panel.add((Component)this.chckbxDiagram10, "14, 12, center, default");
        this.panel_3 = new JPanel();
        this.panel_3.setBorder(new TitledBorder(null, "Closing Relation", 4, 2, null, null));
        panelInputs.add((Component)this.panel_3, "4, 6, 3, 1, right, fill");
        this.panel_3.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.lblRelationType = new JLabel("Relation Type:");
        this.panel_3.add((Component)this.lblRelationType, "2, 1");
        this.cmbbxClosingRelationType = new JComboBox();
        this.cmbbxClosingRelationType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedType = (String)CensusInputWindow.this.cmbbxClosingRelationType.getSelectedItem();
                if (StringUtils.equals((CharSequence)selectedType, (CharSequence)"SPOUSE") || StringUtils.equals((CharSequence)selectedType, (CharSequence)"PARTN") || StringUtils.equals((CharSequence)selectedType, (CharSequence)"OPEN") || StringUtils.equals((CharSequence)selectedType, (CharSequence)"LINEAR") || StringUtils.equals((CharSequence)selectedType, (CharSequence)"COSPOUSE") || selectedType.startsWith("@")) {
                    CensusInputWindow.this.cmbbxClosingRelationEgoRole.setEnabled(false);
                    CensusInputWindow.this.cmbbxClosingRelationAlterRole.setEnabled(false);
                } else {
                    CensusInputWindow.this.cmbbxClosingRelationEgoRole.setEnabled(true);
                    CensusInputWindow.this.cmbbxClosingRelationAlterRole.setEnabled(true);
                    ArrayList<String> roleNames = new ArrayList<String>();
                    roleNames.add("");
                    roleNames.add("ALL");
                    roleNames.addAll(netGUI.getNet().relationModels().getByName(selectedType).roles().nameList());
                    Object[] roleNamesData = roleNames.toArray();
                    CensusInputWindow.this.cmbbxClosingRelationEgoRole.setModel(new DefaultComboBoxModel<Object>(roleNamesData));
                    CensusInputWindow.this.cmbbxClosingRelationAlterRole.setModel(new DefaultComboBoxModel<Object>(roleNamesData));
                }
            }
        });
        this.panel_3.add((Component)this.cmbbxClosingRelationType, "4, 1");
        this.cmbbxClosingRelationType.setEditable(true);
        this.cmbbxClosingRelationType.setModel(new DefaultComboBoxModel<String>(new String[]{"SPOUSE", "PARTN", "OPEN", "LINEAR", "COSPOUSE"}));
        this.lblEgoRole = new JLabel("Ego Role:");
        this.panel_3.add((Component)this.lblEgoRole, "2, 3, right, default");
        this.cmbbxClosingRelationEgoRole = new JComboBox();
        this.panel_3.add((Component)this.cmbbxClosingRelationEgoRole, "4, 3, fill, default");
        this.lblAlterRole = new JLabel("Alter Role:");
        this.panel_3.add((Component)this.lblAlterRole, "2, 5, right, default");
        this.cmbbxClosingRelationAlterRole = new JComboBox();
        this.panel_3.add((Component)this.cmbbxClosingRelationAlterRole, "4, 5, fill, default");
        JLabel lblFilter = new JLabel("Filter:");
        panelInputs.add((Component)lblFilter, "4, 8, right, default");
        this.txtfldFilter = new JTextField();
        this.txtfldFilter.setColumns(10);
        panelInputs.add((Component)this.txtfldFilter, "6, 8, fill, default");
        JLabel lblClassificatoryLinking = new JLabel("Classificatory linking:");
        panelInputs.add((Component)lblClassificatoryLinking, "4, 10, right, default");
        this.cmbbxClassificatoryLinking = new JComboBox();
        this.cmbbxClassificatoryLinking.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
        panelInputs.add((Component)this.cmbbxClassificatoryLinking, "6, 10, fill, default");
        this.lblChainClassification = new JLabel("Chain classification:");
        panelInputs.add((Component)this.lblChainClassification, "4, 12, right, default");
        this.cmbbxClassification = new JComboBox();
        this.cmbbxClassification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.equals((CharSequence)((String)CensusInputWindow.this.cmbbxClassification.getSelectedItem()), (CharSequence)"SIMPLE") || StringUtils.equals((CharSequence)((String)CensusInputWindow.this.cmbbxClassification.getSelectedItem()), (CharSequence)"CLASSIC") || StringUtils.equals((CharSequence)((String)CensusInputWindow.this.cmbbxClassification.getSelectedItem()), (CharSequence)"CLASSIC_GENDERED") || StringUtils.equals((CharSequence)((String)CensusInputWindow.this.cmbbxClassification.getSelectedItem()), (CharSequence)"POSITIONAL")) {
                    CensusInputWindow.this.cmbbxLabel1.setEnabled(true);
                    CensusInputWindow.this.cmbbxLabel2.setEnabled(true);
                    CensusInputWindow.this.cmbbxLabel3.setEnabled(true);
                    CensusInputWindow.this.cmbbxLabel4.setEnabled(true);
                    CensusInputWindow.this.cmbbxLabel5.setEnabled(true);
                    CensusInputWindow.this.cmbbxLabel6.setEnabled(true);
                    CensusInputWindow.this.cmbbxLabel7.setEnabled(true);
                    CensusInputWindow.this.cmbbxLabel8.setEnabled(true);
                    CensusInputWindow.this.cmbbxLabel9.setEnabled(true);
                    CensusInputWindow.this.cmbbxLabel10.setEnabled(true);
                    CensusInputWindow.this.chckbxReport1.setEnabled(true);
                    CensusInputWindow.this.chckbxReport2.setEnabled(true);
                    CensusInputWindow.this.chckbxReport3.setEnabled(true);
                    CensusInputWindow.this.chckbxReport4.setEnabled(true);
                    CensusInputWindow.this.chckbxReport5.setEnabled(true);
                    CensusInputWindow.this.chckbxReport6.setEnabled(true);
                    CensusInputWindow.this.chckbxReport7.setEnabled(true);
                    CensusInputWindow.this.chckbxReport8.setEnabled(true);
                    CensusInputWindow.this.chckbxReport9.setEnabled(true);
                    CensusInputWindow.this.chckbxReport10.setEnabled(true);
                    CensusInputWindow.this.chckbxDiagram1.setEnabled(true);
                    CensusInputWindow.this.chckbxDiagram2.setEnabled(true);
                    CensusInputWindow.this.chckbxDiagram3.setEnabled(true);
                    CensusInputWindow.this.chckbxDiagram4.setEnabled(true);
                    CensusInputWindow.this.chckbxDiagram5.setEnabled(true);
                    CensusInputWindow.this.chckbxDiagram6.setEnabled(true);
                    CensusInputWindow.this.chckbxDiagram7.setEnabled(true);
                    CensusInputWindow.this.chckbxDiagram8.setEnabled(true);
                    CensusInputWindow.this.chckbxDiagram9.setEnabled(true);
                    CensusInputWindow.this.chckbxDiagram10.setEnabled(true);
                } else {
                    CensusInputWindow.this.cmbbxLabel1.setEnabled(false);
                    CensusInputWindow.this.cmbbxLabel2.setEnabled(false);
                    CensusInputWindow.this.cmbbxLabel3.setEnabled(false);
                    CensusInputWindow.this.cmbbxLabel4.setEnabled(false);
                    CensusInputWindow.this.cmbbxLabel5.setEnabled(false);
                    CensusInputWindow.this.cmbbxLabel6.setEnabled(false);
                    CensusInputWindow.this.cmbbxLabel7.setEnabled(false);
                    CensusInputWindow.this.cmbbxLabel8.setEnabled(false);
                    CensusInputWindow.this.cmbbxLabel9.setEnabled(false);
                    CensusInputWindow.this.cmbbxLabel10.setEnabled(false);
                    CensusInputWindow.this.chckbxReport1.setEnabled(false);
                    CensusInputWindow.this.chckbxReport2.setEnabled(false);
                    CensusInputWindow.this.chckbxReport3.setEnabled(false);
                    CensusInputWindow.this.chckbxReport4.setEnabled(false);
                    CensusInputWindow.this.chckbxReport5.setEnabled(false);
                    CensusInputWindow.this.chckbxReport6.setEnabled(false);
                    CensusInputWindow.this.chckbxReport7.setEnabled(false);
                    CensusInputWindow.this.chckbxReport8.setEnabled(false);
                    CensusInputWindow.this.chckbxReport9.setEnabled(false);
                    CensusInputWindow.this.chckbxReport10.setEnabled(false);
                    CensusInputWindow.this.chckbxDiagram1.setEnabled(false);
                    CensusInputWindow.this.chckbxDiagram2.setEnabled(false);
                    CensusInputWindow.this.chckbxDiagram3.setEnabled(false);
                    CensusInputWindow.this.chckbxDiagram4.setEnabled(false);
                    CensusInputWindow.this.chckbxDiagram5.setEnabled(false);
                    CensusInputWindow.this.chckbxDiagram6.setEnabled(false);
                    CensusInputWindow.this.chckbxDiagram7.setEnabled(false);
                    CensusInputWindow.this.chckbxDiagram8.setEnabled(false);
                    CensusInputWindow.this.chckbxDiagram9.setEnabled(false);
                    CensusInputWindow.this.chckbxDiagram10.setEnabled(false);
                }
            }
        });
        this.cmbbxClassification.setModel(new DefaultComboBoxModel<ChainValuator.ChainProperty>(ChainValuator.ChainProperty.values()));
        panelInputs.add((Component)this.cmbbxClassification, "6, 12, fill, default");
        this.chckbxMarriedOnly = new JCheckBox("Couples only");
        panelInputs.add((Component)this.chckbxMarriedOnly, "4, 14");
        this.chckbxCrossSex = new JCheckBox("Cross-sex chains only");
        this.chckbxCrossSex.setSelected(true);
        panelInputs.add((Component)this.chckbxCrossSex, "6, 14");
        this.chckbxMarkIndividuals = new JCheckBox("Mark Individuals");
        panelInputs.add((Component)this.chckbxMarkIndividuals, "4, 16, default, top");
        this.chckbxOpenChainFrequencies = new JCheckBox("Open Chains Frequencies");
        panelInputs.add((Component)this.chckbxOpenChainFrequencies, "6, 16");
        this.panel_2 = new JPanel();
        this.panel_2.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "Circuit to include in Pajek format", 4, 2, null, new Color(51, 51, 51)));
        panelInputs.add((Component)this.panel_2, "10, 10, 1, 5, fill, fill");
        this.panel_2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.chckbxCircuitInduced = new JCheckBox("Circuit induced network");
        this.panel_2.add((Component)this.chckbxCircuitInduced, "4, 2");
        this.chckbxCircuitIntersection = new JCheckBox("Circuit intersection network");
        this.panel_2.add((Component)this.chckbxCircuitIntersection, "2, 4");
        this.chckbxCircuitInducedFrame = new JCheckBox("Circuit induced frame network");
        this.panel_2.add((Component)this.chckbxCircuitInducedFrame, "4, 4");
        this.chckbxCircuitNetworks = new JCheckBox("Circuit as networks");
        this.panel_2.add((Component)this.chckbxCircuitNetworks, "2, 2");
        this.chckbxCircuitsAsRelations = new JCheckBox("Circuits as Relations");
        panelInputs.add((Component)this.chckbxCircuitsAsRelations, "4, 18");
        this.chckbxListOutofcircuitPairs = new JCheckBox("List out-of-circuit pairs");
        panelInputs.add((Component)this.chckbxListOutofcircuitPairs, "6, 18");
        this.chckbxListAllPerspectives = new JCheckBox("List all perspectives");
        panelInputs.add((Component)this.chckbxListAllPerspectives, "6, 20");
        JPanel panel_1 = new JPanel();
        panelInputs.add((Component)panel_1, "4, 22, 7, 1, fill, fill");
        panel_1.setLayout(new GridLayout(0, 5, 0, 0));
        JPanel panelCircuitType = new JPanel();
        panel_1.add(panelCircuitType);
        panelCircuitType.setBorder(new TitledBorder(null, "Circuit Type", 4, 2, null, new Color(51, 51, 51)));
        panelCircuitType.setLayout(new BoxLayout(panelCircuitType, 1));
        this.rdbtnCircuitTypeCircuit = new JRadioButton("Circuit");
        panelCircuitType.add(this.rdbtnCircuitTypeCircuit);
        this.rdbtnCircuitTypeCircuit.setSelected(true);
        this.buttonGroupCircuit.add(this.rdbtnCircuitTypeCircuit);
        this.rdbtnCircuitTypeRing = new JRadioButton("Ring");
        panelCircuitType.add(this.rdbtnCircuitTypeRing);
        this.buttonGroupCircuit.add(this.rdbtnCircuitTypeRing);
        this.rdbtnCircuitTypeMinor = new JRadioButton("Minor");
        panelCircuitType.add(this.rdbtnCircuitTypeMinor);
        this.buttonGroupCircuit.add(this.rdbtnCircuitTypeMinor);
        this.rdbtnCircuitTypeMinimal = new JRadioButton("Minimal");
        panelCircuitType.add(this.rdbtnCircuitTypeMinimal);
        this.buttonGroupCircuit.add(this.rdbtnCircuitTypeMinimal);
        JPanel panelFiliationType = new JPanel();
        panel_1.add(panelFiliationType);
        panelFiliationType.setBorder(new TitledBorder(null, "Filiation Type", 4, 2, null, null));
        panelFiliationType.setLayout(new BoxLayout(panelFiliationType, 1));
        this.rdbtnFiliationAgnatic = new JRadioButton("Agnatic");
        this.buttonGroupFiliation.add(this.rdbtnFiliationAgnatic);
        panelFiliationType.add(this.rdbtnFiliationAgnatic);
        this.rdbtnFiliationUterine = new JRadioButton("Uterine");
        this.buttonGroupFiliation.add(this.rdbtnFiliationUterine);
        panelFiliationType.add(this.rdbtnFiliationUterine);
        this.rdbtnFiliationCognatic = new JRadioButton("Cognatic");
        this.buttonGroupFiliation.add(this.rdbtnFiliationCognatic);
        this.rdbtnFiliationCognatic.setSelected(true);
        panelFiliationType.add(this.rdbtnFiliationCognatic);
        this.rdbtnFiliationBilateral = new JRadioButton("Bilateral");
        this.buttonGroupFiliation.add(this.rdbtnFiliationBilateral);
        panelFiliationType.add(this.rdbtnFiliationBilateral);
        JPanel panelRestrictionType = new JPanel();
        panel_1.add(panelRestrictionType);
        panelRestrictionType.setBorder(new TitledBorder(null, "Restriction Type", 4, 2, null, null));
        panelRestrictionType.setLayout(new BoxLayout(panelRestrictionType, 1));
        this.rdbtnRestrictionNone = new JRadioButton("None");
        this.buttonGroupRestriction.add(this.rdbtnRestrictionNone);
        this.rdbtnRestrictionNone.setSelected(true);
        panelRestrictionType.add(this.rdbtnRestrictionNone);
        this.rdbtnRestrictionSome = new JRadioButton("Some");
        this.buttonGroupRestriction.add(this.rdbtnRestrictionSome);
        panelRestrictionType.add(this.rdbtnRestrictionSome);
        this.rdbtnRestrictionAll = new JRadioButton("All");
        this.buttonGroupRestriction.add(this.rdbtnRestrictionAll);
        panelRestrictionType.add(this.rdbtnRestrictionAll);
        this.rdbtnRestrictionLastMarried = new JRadioButton("Last Married");
        this.buttonGroupRestriction.add(this.rdbtnRestrictionLastMarried);
        panelRestrictionType.add(this.rdbtnRestrictionLastMarried);
        JPanel panelSiblingMode = new JPanel();
        panel_1.add(panelSiblingMode);
        panelSiblingMode.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Sibling Types", 4, 2, null, new Color(0, 0, 0)));
        panelSiblingMode.setLayout(new BoxLayout(panelSiblingMode, 1));
        this.rdbtnSibNone = new JRadioButton("2 (None)");
        this.rdbtnSibNone.setToolTipText("No siblings assimilated.");
        panelSiblingMode.add(this.rdbtnSibNone);
        this.buttonGroupSib.add(this.rdbtnSibNone);
        this.rdbtnSibFull = new JRadioButton("3 (Full)");
        this.rdbtnSibFull.setToolTipText("Full siblings assimilated.");
        panelSiblingMode.add(this.rdbtnSibFull);
        this.rdbtnSibFull.setSelected(true);
        this.buttonGroupSib.add(this.rdbtnSibFull);
        this.rdbtnSibAll = new JRadioButton("1 (All)");
        this.rdbtnSibAll.setToolTipText("All siblings assimilated.");
        panelSiblingMode.add(this.rdbtnSibAll);
        this.buttonGroupSib.add(this.rdbtnSibAll);
        JPanel panelSymmetryType = new JPanel();
        panel_1.add(panelSymmetryType);
        panelSymmetryType.setBorder(new TitledBorder(null, "Symmetry Type", 4, 2, null, null));
        panelSymmetryType.setLayout(new BoxLayout(panelSymmetryType, 1));
        this.rdbtnSymmetryInvariable = new JRadioButton("Invariable");
        this.rdbtnSymmetryInvariable.setToolTipText("Not permutable.");
        panelSymmetryType.add(this.rdbtnSymmetryInvariable);
        this.buttonGroupSymmetry.add(this.rdbtnSymmetryInvariable);
        this.rdbtnSymmetryInvertible = new JRadioButton("Invertible");
        this.rdbtnSymmetryInvertible.setToolTipText("Ego-alter reflection possible.");
        panelSymmetryType.add(this.rdbtnSymmetryInvertible);
        this.buttonGroupSymmetry.add(this.rdbtnSymmetryInvertible);
        this.rdbtnSymmetryPermutable = new JRadioButton("Fully Permutable");
        panelSymmetryType.add(this.rdbtnSymmetryPermutable);
        this.rdbtnSymmetryPermutable.setSelected(true);
        this.buttonGroupSymmetry.add(this.rdbtnSymmetryPermutable);
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CensusInputWindow.this.dispose();
            }
        });
        this.btnRestoreDefaults = new JButton("Restore Defaults");
        this.btnRestoreDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CensusCriteria criteria = new CensusCriteria();
                CensusInputWindow.this.setCriteria(criteria);
            }
        });
        buttonPanel.add(this.btnRestoreDefaults);
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CensusCriteria criteria = CensusInputWindow.this.getCriteria();
                    PuckGUI.instance().getPreferences().setCensusCriteria(criteria);
                    if (criteria.getClosingRelationEgoRole().equals("ALL") || criteria.getClosingRelationAlterRole().equals("ALL")) {
                        ArrayList<CensusCriteria> criteriaList = new ArrayList<CensusCriteria>();
                        int i = 2;
                        while (i < CensusInputWindow.this.cmbbxClosingRelationEgoRole.getItemCount()) {
                            if (criteria.getClosingRelationEgoRole().equals("ALL") || criteria.getClosingRelationEgoRole().equals(CensusInputWindow.this.cmbbxClosingRelationEgoRole.getItemAt(i))) {
                                int k = 2;
                                if (criteria.getClosingRelationEgoRole().equals("ALL")) {
                                    k = i;
                                }
                                int j = k;
                                while (j < CensusInputWindow.this.cmbbxClosingRelationEgoRole.getItemCount()) {
                                    if (criteria.getClosingRelationAlterRole().equals("ALL") || criteria.getClosingRelationAlterRole().equals(CensusInputWindow.this.cmbbxClosingRelationAlterRole.getItemAt(j))) {
                                        CensusCriteria partialCriteria = CensusInputWindow.this.getCriteria();
                                        partialCriteria.setClosingRelationEgoRole((String)CensusInputWindow.this.cmbbxClosingRelationEgoRole.getItemAt(i));
                                        partialCriteria.setClosingRelationAlterRole((String)CensusInputWindow.this.cmbbxClosingRelationAlterRole.getItemAt(j));
                                        criteriaList.add(partialCriteria);
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        for (Report report : CensusReporter.reportMultipleCensus(netGUI.getSegmentation(), criteriaList)) {
                            netGUI.addReportTab(report);
                        }
                    } else {
                        CircuitFinder finder = new CircuitFinder(netGUI.getSegmentation(), criteria);
                        Report report = CensusReporter.reportFindCircuit(finder, netGUI.getSegmentation(), criteria, netGUI.getFile());
                        if (criteria.isCircuitInducedNetwork()) {
                            Net newNet = CensusUtils.createCircuitInducedNet(finder);
                            NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
                            newNetGui.setChanged(true, "-circuits-" + finder.getPattern());
                        }
                        netGUI.addReportTab(report);
                        if (criteria.isCircuitsAsRelations()) {
                            String name;
                            String label = name = "Circuits_" + finder.getPattern();
                            int i = 0;
                            while (netGUI.getNet().relationModels().getByName(label) != null) {
                                label = String.valueOf(name) + " " + ++i;
                            }
                            RelationModel model = netGUI.getNet().createRelationModel(label);
                            NetUtils.createRelationsFromCircuits(netGUI.getNet(), finder, model);
                            netGUI.setChanged(true);
                            netGUI.addRelationTab(model);
                            netGUI.updateAll();
                        }
                    }
                    CensusInputWindow.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(CensusInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
        this.btnLaunchWithReshuffling = new JButton("Launch with Reshuffling");
        this.btnLaunchWithReshuffling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CensusCriteria criteria = CensusInputWindow.this.getCriteria();
                    ShuffleCriteria shuffleCriteria = new ShuffleCriteria();
                    shuffleCriteria.setSwitchesPerIteration(2);
                    shuffleCriteria.setMaxGenerationalDistance(2);
                    shuffleCriteria.setMinShufflePercentage(50.0);
                    shuffleCriteria.setMinStableIterations(100);
                    shuffleCriteria.setMode(OMGraph.GraphMode.OREGRAPH);
                    int runs = 10;
                    PuckGUI.instance().getPreferences().setCensusCriteria(criteria);
                    Report report2 = CensusReporter.reportFindCircuitsReshuffled(netGUI.getNet(), shuffleCriteria, runs, criteria);
                    netGUI.addReportTab(report2);
                    CensusInputWindow.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(CensusInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(this.btnLaunchWithReshuffling);
        this.setCriteria(PuckGUI.instance().getPreferences().getCensusCriteria());
    }

    public CensusCriteria getCriteria() {
        CensusCriteria result = new CensusCriteria();
        result.setPattern(this.txtfldPattern.getText());
        result.setFilter(this.txtfldFilter.getText());
        result.setClassificatoryLinking((String)this.cmbbxClassificatoryLinking.getSelectedItem());
        result.setClosingRelation((String)this.cmbbxClosingRelationType.getSelectedItem());
        result.setClosingRelationEgoRole((String)this.cmbbxClosingRelationEgoRole.getSelectedItem());
        result.setClosingRelationAlterRole((String)this.cmbbxClosingRelationAlterRole.getSelectedItem());
        result.setChainClassification((String)this.cmbbxClassification.getSelectedItem());
        result.setCrossSexChainsOnly(this.chckbxCrossSex.isSelected());
        result.setMarriedOnly(this.chckbxMarriedOnly.isSelected());
        result.setMarkIndividuals(this.chckbxMarkIndividuals.isSelected());
        result.setOpenChainFrequencies(this.chckbxOpenChainFrequencies.isSelected());
        result.setCircuitsAsRelations(this.chckbxCircuitsAsRelations.isSelected());
        result.setWithOutOfCircuitCouples(this.chckbxListOutofcircuitPairs.isSelected());
        result.setWithAllPerspectives(this.chckbxListAllPerspectives.isSelected());
        CircuitType circuitType = this.rdbtnCircuitTypeCircuit.isSelected() ? CircuitType.CIRCUIT : (this.rdbtnCircuitTypeMinimal.isSelected() ? CircuitType.MINIMAL : (this.rdbtnCircuitTypeMinor.isSelected() ? CircuitType.MINOR : (this.rdbtnCircuitTypeRing.isSelected() ? CircuitType.RING : null)));
        result.setCircuitType(circuitType);
        FiliationType filiationType = this.rdbtnFiliationAgnatic.isSelected() ? FiliationType.AGNATIC : (this.rdbtnFiliationBilateral.isSelected() ? FiliationType.BILINEAR : (this.rdbtnFiliationCognatic.isSelected() ? FiliationType.COGNATIC : (this.rdbtnFiliationUterine.isSelected() ? FiliationType.UTERINE : null)));
        result.setFiliationType(filiationType);
        RestrictionType restrictionType = this.rdbtnRestrictionAll.isSelected() ? RestrictionType.ALL : (this.rdbtnRestrictionLastMarried.isSelected() ? RestrictionType.LASTMARRIED : (this.rdbtnRestrictionNone.isSelected() ? RestrictionType.NONE : (this.rdbtnRestrictionSome.isSelected() ? RestrictionType.SOME : null)));
        result.setRestrictionType(restrictionType);
        SiblingMode siblingMode = this.rdbtnSibAll.isSelected() ? SiblingMode.ALL : (this.rdbtnSibFull.isSelected() ? SiblingMode.FULL : (this.rdbtnSibNone.isSelected() ? SiblingMode.NONE : null));
        result.setSiblingMode(siblingMode);
        SymmetryType symmetryType = this.rdbtnSymmetryInvariable.isSelected() ? SymmetryType.INVARIABLE : (this.rdbtnSymmetryInvertible.isSelected() ? SymmetryType.INVERTIBLE : (this.rdbtnSymmetryPermutable.isSelected() ? SymmetryType.PERMUTABLE : null));
        result.setSymmetryType(symmetryType);
        result.getCensusDetails().clear();
        result.getCensusDetails().add((String)this.cmbbxLabel1.getSelectedItem(), this.chckbxReport1.isSelected(), this.chckbxDiagram1.isSelected());
        result.getCensusDetails().add((String)this.cmbbxLabel2.getSelectedItem(), this.chckbxReport2.isSelected(), this.chckbxDiagram2.isSelected());
        result.getCensusDetails().add((String)this.cmbbxLabel3.getSelectedItem(), this.chckbxReport3.isSelected(), this.chckbxDiagram3.isSelected());
        result.getCensusDetails().add((String)this.cmbbxLabel4.getSelectedItem(), this.chckbxReport4.isSelected(), this.chckbxDiagram4.isSelected());
        result.getCensusDetails().add((String)this.cmbbxLabel5.getSelectedItem(), this.chckbxReport5.isSelected(), this.chckbxDiagram5.isSelected());
        result.getCensusDetails().add((String)this.cmbbxLabel6.getSelectedItem(), this.chckbxReport6.isSelected(), this.chckbxDiagram6.isSelected());
        result.getCensusDetails().add((String)this.cmbbxLabel7.getSelectedItem(), this.chckbxReport7.isSelected(), this.chckbxDiagram7.isSelected());
        result.getCensusDetails().add((String)this.cmbbxLabel8.getSelectedItem(), this.chckbxReport8.isSelected(), this.chckbxDiagram8.isSelected());
        result.getCensusDetails().add((String)this.cmbbxLabel9.getSelectedItem(), this.chckbxReport9.isSelected(), this.chckbxDiagram9.isSelected());
        result.getCensusDetails().add((String)this.cmbbxLabel10.getSelectedItem(), this.chckbxReport10.isSelected(), this.chckbxDiagram10.isSelected());
        result.setCircuitInducedNetwork(this.chckbxCircuitInduced.isSelected());
        result.setCircuitInduceFrameNetwork(this.chckbxCircuitInducedFrame.isSelected());
        result.setCircuitIntersectionNetwork(this.chckbxCircuitIntersection.isSelected());
        result.setCircuitNetworks(this.chckbxCircuitNetworks.isSelected());
        return result;
    }

    public void setCriteria(CensusCriteria source) {
        if (source != null) {
            int chainClassificationLabelIndex;
            this.txtfldPattern.setText(source.getPattern());
            this.txtfldFilter.setText(source.getFilter());
            ArrayList<String> classificatoryLinkingLabels = new ArrayList<String>(20);
            classificatoryLinkingLabels.add("");
            classificatoryLinkingLabels.addAll(IndividualValuator.getExogenousAttributeLabels(this.netGUI.getCurrentIndividuals()));
            this.cmbbxClassificatoryLinking.setModel(new DefaultComboBoxModel<Object>(classificatoryLinkingLabels.toArray()));
            if (StringUtils.isBlank((CharSequence)source.getClassificatoryLinking())) {
                this.cmbbxClassificatoryLinking.setSelectedIndex(0);
            } else {
                int classificatoryLinkingLabelIndex = classificatoryLinkingLabels.indexOf(source.getClassificatoryLinking());
                if (classificatoryLinkingLabelIndex == -1) {
                    this.cmbbxClassificatoryLinking.setSelectedIndex(0);
                } else {
                    this.cmbbxClassificatoryLinking.setSelectedIndex(classificatoryLinkingLabelIndex);
                }
            }
            ArrayList<String> closingRelationLabels = new ArrayList<String>();
            closingRelationLabels.add("SPOUSE");
            closingRelationLabels.add("PARTN");
            closingRelationLabels.add("OPEN");
            closingRelationLabels.add("LINEAR");
            closingRelationLabels.add("COSPOUSE");
            closingRelationLabels.addAll(this.netGUI.getNet().relationModels().sortedNameList());
            for (String label : IndividualValuator.getExogenousAttributeLabels(this.netGUI.getCurrentIndividuals())) {
                closingRelationLabels.add("@" + label);
            }
            this.cmbbxClosingRelationType.setModel(new DefaultComboBoxModel<Object>(closingRelationLabels.toArray()));
            if (StringUtils.isBlank((CharSequence)source.getClosingRelation())) {
                this.cmbbxClosingRelationType.setSelectedIndex(0);
            } else if (closingRelationLabels.contains(source.getClosingRelation())) {
                this.cmbbxClosingRelationType.setSelectedIndex(closingRelationLabels.indexOf(source.getClosingRelation()));
            } else {
                this.cmbbxClosingRelationType.setSelectedIndex(0);
            }
            this.cmbbxClassification.setModel(new DefaultComboBoxModel<String>(endogenousLabels));
            if (StringUtils.isBlank((CharSequence)source.getChainClassification())) {
                chainClassificationLabelIndex = ArrayUtils.indexOf((Object[])endogenousLabels, (Object)"SIMPLE");
            } else {
                chainClassificationLabelIndex = ArrayUtils.indexOf((Object[])endogenousLabels, (Object)source.getChainClassification());
                if (chainClassificationLabelIndex == -1) {
                    chainClassificationLabelIndex = ArrayUtils.indexOf((Object[])endogenousLabels, (Object)"SIMPLE");
                }
            }
            this.cmbbxClassification.setSelectedIndex(chainClassificationLabelIndex);
            this.chckbxCrossSex.setSelected(source.isCrossSexChainsOnly());
            this.chckbxMarriedOnly.setSelected(source.isCouplesOnly());
            this.chckbxMarkIndividuals.setSelected(source.isMarkIndividuals());
            this.chckbxOpenChainFrequencies.setSelected(source.isOpenChainFrequencies());
            this.chckbxCircuitsAsRelations.setSelected(source.isCircuitsAsRelations());
            this.chckbxListOutofcircuitPairs.setSelected(source.isWithOutOfCircuitCouples());
            this.chckbxListAllPerspectives.setSelected(source.isWithAllPerspectives());
            this.rdbtnCircuitTypeCircuit.setSelected(false);
            this.rdbtnCircuitTypeMinimal.setSelected(false);
            this.rdbtnCircuitTypeMinor.setSelected(false);
            this.rdbtnCircuitTypeRing.setSelected(false);
            switch (source.getCircuitType()) {
                case CIRCUIT: {
                    this.rdbtnCircuitTypeCircuit.setSelected(true);
                    break;
                }
                case MINIMAL: {
                    this.rdbtnCircuitTypeMinimal.setSelected(true);
                    break;
                }
                case MINOR: {
                    this.rdbtnCircuitTypeMinor.setSelected(true);
                    break;
                }
                case RING: {
                    this.rdbtnCircuitTypeRing.setSelected(true);
                }
            }
            this.rdbtnFiliationAgnatic.setSelected(false);
            this.rdbtnFiliationBilateral.setSelected(false);
            this.rdbtnFiliationCognatic.setSelected(false);
            this.rdbtnFiliationUterine.setSelected(false);
            switch (source.getFiliationType()) {
                case AGNATIC: {
                    this.rdbtnFiliationAgnatic.setSelected(true);
                    break;
                }
                case BILINEAR: {
                    this.rdbtnFiliationBilateral.setSelected(true);
                    break;
                }
                case COGNATIC: {
                    this.rdbtnFiliationCognatic.setSelected(true);
                    break;
                }
                case UTERINE: {
                    this.rdbtnFiliationUterine.setSelected(true);
                }
            }
            this.rdbtnRestrictionAll.setSelected(false);
            this.rdbtnRestrictionLastMarried.setSelected(false);
            this.rdbtnRestrictionNone.setSelected(false);
            this.rdbtnRestrictionSome.setSelected(false);
            switch (source.getRestrictionType()) {
                case ALL: {
                    this.rdbtnRestrictionAll.setSelected(true);
                    break;
                }
                case LASTMARRIED: {
                    this.rdbtnRestrictionLastMarried.setSelected(true);
                    break;
                }
                case NONE: {
                    this.rdbtnRestrictionNone.setSelected(true);
                    break;
                }
                case SOME: {
                    this.rdbtnRestrictionSome.setSelected(true);
                }
            }
            this.rdbtnSibAll.setSelected(false);
            this.rdbtnSibFull.setSelected(false);
            this.rdbtnSibNone.setSelected(false);
            switch (source.getSiblingMode()) {
                case ALL: {
                    this.rdbtnSibAll.setSelected(true);
                    break;
                }
                case FULL: {
                    this.rdbtnSibFull.setSelected(true);
                    break;
                }
                case NONE: {
                    this.rdbtnSibNone.setSelected(true);
                }
            }
            this.rdbtnSymmetryInvariable.setSelected(false);
            this.rdbtnSymmetryInvertible.setSelected(false);
            this.rdbtnSymmetryPermutable.setSelected(false);
            switch (source.getSymmetryType()) {
                case INVARIABLE: {
                    this.rdbtnSymmetryInvariable.setSelected(true);
                    break;
                }
                case INVERTIBLE: {
                    this.rdbtnSymmetryInvertible.setSelected(true);
                    break;
                }
                case PERMUTABLE: {
                    this.rdbtnSymmetryPermutable.setSelected(true);
                }
            }
            this.cmbbxLabel1.setSelectedIndex(ArrayUtils.indexOf((Object[])endogenousLabels, (Object)((CensusDetail)source.getCensusDetails().get(0)).getLabel()));
            this.cmbbxLabel2.setSelectedIndex(ArrayUtils.indexOf((Object[])endogenousLabels, (Object)((CensusDetail)source.getCensusDetails().get(1)).getLabel()));
            this.cmbbxLabel3.setSelectedIndex(ArrayUtils.indexOf((Object[])endogenousLabels, (Object)((CensusDetail)source.getCensusDetails().get(2)).getLabel()));
            this.cmbbxLabel4.setSelectedIndex(ArrayUtils.indexOf((Object[])endogenousLabels, (Object)((CensusDetail)source.getCensusDetails().get(3)).getLabel()));
            this.cmbbxLabel5.setSelectedIndex(ArrayUtils.indexOf((Object[])endogenousLabels, (Object)((CensusDetail)source.getCensusDetails().get(4)).getLabel()));
            this.cmbbxLabel6.setSelectedIndex(ArrayUtils.indexOf((Object[])endogenousLabels, (Object)((CensusDetail)source.getCensusDetails().get(5)).getLabel()));
            this.cmbbxLabel7.setSelectedIndex(ArrayUtils.indexOf((Object[])endogenousLabels, (Object)((CensusDetail)source.getCensusDetails().get(6)).getLabel()));
            this.cmbbxLabel8.setSelectedIndex(ArrayUtils.indexOf((Object[])endogenousLabels, (Object)((CensusDetail)source.getCensusDetails().get(7)).getLabel()));
            this.cmbbxLabel9.setSelectedIndex(ArrayUtils.indexOf((Object[])endogenousLabels, (Object)((CensusDetail)source.getCensusDetails().get(8)).getLabel()));
            this.cmbbxLabel10.setSelectedIndex(ArrayUtils.indexOf((Object[])endogenousLabels, (Object)((CensusDetail)source.getCensusDetails().get(9)).getLabel()));
            this.chckbxReport1.setSelected(((CensusDetail)source.getCensusDetails().get(0)).isReport());
            this.chckbxReport2.setSelected(((CensusDetail)source.getCensusDetails().get(1)).isReport());
            this.chckbxReport3.setSelected(((CensusDetail)source.getCensusDetails().get(2)).isReport());
            this.chckbxReport4.setSelected(((CensusDetail)source.getCensusDetails().get(3)).isReport());
            this.chckbxReport5.setSelected(((CensusDetail)source.getCensusDetails().get(4)).isReport());
            this.chckbxReport6.setSelected(((CensusDetail)source.getCensusDetails().get(5)).isReport());
            this.chckbxReport7.setSelected(((CensusDetail)source.getCensusDetails().get(6)).isReport());
            this.chckbxReport8.setSelected(((CensusDetail)source.getCensusDetails().get(7)).isReport());
            this.chckbxReport9.setSelected(((CensusDetail)source.getCensusDetails().get(8)).isReport());
            this.chckbxReport10.setSelected(((CensusDetail)source.getCensusDetails().get(9)).isReport());
            this.chckbxDiagram1.setSelected(((CensusDetail)source.getCensusDetails().get(0)).isDiagram());
            this.chckbxDiagram2.setSelected(((CensusDetail)source.getCensusDetails().get(1)).isDiagram());
            this.chckbxDiagram3.setSelected(((CensusDetail)source.getCensusDetails().get(2)).isDiagram());
            this.chckbxDiagram4.setSelected(((CensusDetail)source.getCensusDetails().get(3)).isDiagram());
            this.chckbxDiagram5.setSelected(((CensusDetail)source.getCensusDetails().get(4)).isDiagram());
            this.chckbxDiagram6.setSelected(((CensusDetail)source.getCensusDetails().get(5)).isDiagram());
            this.chckbxDiagram7.setSelected(((CensusDetail)source.getCensusDetails().get(6)).isDiagram());
            this.chckbxDiagram8.setSelected(((CensusDetail)source.getCensusDetails().get(7)).isDiagram());
            this.chckbxDiagram9.setSelected(((CensusDetail)source.getCensusDetails().get(8)).isDiagram());
            this.chckbxDiagram10.setSelected(((CensusDetail)source.getCensusDetails().get(9)).isDiagram());
            this.chckbxCircuitInduced.setSelected(source.isCircuitInducedNetwork());
            this.chckbxCircuitInducedFrame.setSelected(source.isCircuitInducedFrameNetwork());
            this.chckbxCircuitIntersection.setSelected(source.isCircuitIntersectionNetwork());
            this.chckbxCircuitNetworks.setSelected(source.isCircuitNetworks());
        }
    }
}

