/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts.sugiyama;

import org.gephi.graph.api.Node;
import org.gephi.graph.spi.LayoutData;

class NodeWrapper
implements LayoutData,
Comparable<NodeWrapper> {
    private double edgeCrossesIndicator = 0.0;
    private int additions = 0;
    private int level = 0;
    private int gridPosition = 0;
    private int priority = 0;

    public static void initData(Node node, NodeWrapper wrapper) {
        NodeWrapper nodeData = (NodeWrapper)node.getNodeData().getLayoutData();
        if (nodeData == null) {
            node.getNodeData().setLayoutData((LayoutData)wrapper);
        }
    }

    public static NodeWrapper getData(Node node) {
        return (NodeWrapper)node.getNodeData().getLayoutData();
    }

    public static void clean(Node node) {
        NodeWrapper nodeData = NodeWrapper.getData(node);
        if (nodeData != null) {
            node.getNodeData().setLayoutData(null);
        }
    }

    NodeWrapper(int level, double edgeCrossesIndicator) {
        this.level = level;
        this.edgeCrossesIndicator = edgeCrossesIndicator;
        ++this.additions;
    }

    double getEdgeCrossesIndicator() {
        if (this.additions == 0) {
            return 0.0;
        }
        return this.edgeCrossesIndicator / (double)this.additions;
    }

    void addToEdgeCrossesIndicator(double addValue) {
        this.edgeCrossesIndicator += addValue;
        ++this.additions;
    }

    int getLevel() {
        return this.level;
    }

    int getGridPosition() {
        return this.gridPosition;
    }

    void setGridPosition(int pos) {
        this.gridPosition = pos;
    }

    void incrementPriority() {
        ++this.priority;
    }

    int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(NodeWrapper compare) {
        if (compare.getEdgeCrossesIndicator() == this.getEdgeCrossesIndicator()) {
            return 0;
        }
        double compareValue = compare.getEdgeCrossesIndicator() - this.getEdgeCrossesIndicator();
        return (int)Math.round(compareValue);
    }
}

