/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.containers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gephi.graph.api.Node;
import org.tip.puck.visualization.layouts.GraphSource;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.ChainCluster;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.ColoredChain;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.NodeLayoutData;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.containers.BorderContainer;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.containers.LeafContainer;

public class ChainContainer {
    final ColoredChain chain;
    protected Set<ChainContainer> children = new HashSet<ChainContainer>();
    protected ChainCluster rootCluster = null;
    protected int origin;

    public void setRootCluster(ChainCluster rootCluster) {
        this.rootCluster = rootCluster;
    }

    public ChainCluster getRootCluster() {
        return this.rootCluster;
    }

    protected ChainContainer(ColoredChain chain) {
        this.chain = chain;
    }

    public static final ChainContainer getContainer(Node root, GraphSource graphSource) {
        ColoredChain chain = ColoredChain.createDownChain(root, graphSource);
        ChainContainer result = null;
        Node bottomNode = chain.getBottomNode();
        Set<Node> children = graphSource.getChildren(bottomNode);
        if (children.isEmpty()) {
            result = new LeafContainer(chain);
        } else {
            Iterator<Node> iterator = children.iterator();
            boolean canGo = true;
            while (iterator.hasNext() && canGo) {
                Node child = iterator.next();
                if (!NodeLayoutData.isColored(child, NodeLayoutData.Color.RED)) continue;
                canGo = false;
            }
            result = !canGo ? new BorderContainer(chain) : new ChainContainer(chain);
        }
        return result;
    }

    public void populateChildren(GraphSource graphSource) {
        Node bottomNode = this.chain.getBottomNode();
        Set<Node> bottomChildren = graphSource.getChildren(bottomNode);
        for (Node node : bottomChildren) {
            if (NodeLayoutData.isColored(node, NodeLayoutData.Color.RED)) {
                System.out.println("Error ChainContainer has Red Child");
                continue;
            }
            ChainContainer container = ChainContainer.getContainer(node, graphSource);
            container.setRootCluster(this.rootCluster);
            container.setOrigin(this.origin + this.chain.getHeight() + 1);
            if (container instanceof BorderContainer) {
                this.rootCluster.addBorder((BorderContainer)container);
            }
            this.children.add(container);
        }
        for (ChainContainer chainContainer : this.children) {
            chainContainer.populateChildren(graphSource);
        }
    }

    public boolean isLeaf() {
        return false;
    }

    public ColoredChain getChain() {
        return this.chain;
    }

    public Set<ChainContainer> getChildren() {
        if (this.isLeaf()) {
            return Collections.emptySet();
        }
        return this.children;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public int getOrigin() {
        return this.origin;
    }

    public int getHeight() {
        int result = this.chain.getHeight();
        int maxHeight = 0;
        if (!this.isLeaf()) {
            for (ChainContainer child : this.children) {
                maxHeight = Math.max(maxHeight, child.getHeight());
            }
        }
        return result + maxHeight;
    }

    public int getWidth() {
        int width = 0;
        if (!this.isLeaf()) {
            for (ChainContainer child : this.children) {
                width += child.getWidth();
            }
        }
        return Math.max(1, width);
    }

    public int getSize() {
        int size = this.chain.getHeight();
        for (ChainContainer chainContainer : this.children) {
            size += chainContainer.getSize();
        }
        return size;
    }

    public int getArea() {
        return this.getWidth() * this.getHeight();
    }

    public float getDensity() {
        return (float)this.getSize() * 1.0f / ((float)this.getArea() * 1.0f);
    }
}

