/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.workers.ExpansionMode;

public class SequenceCensusCriteria {
    private CensusType censusType;
    private RelationAttributeType relationAttributeType;
    private List<RelationAttributeType> relationAttributeTypes;
    private String egoRoleName;
    private double threshold;
    private GeoLevel level;
    private String splitLabel;
    private Map<String, List<String>> partitionLabels;
    private String eventModelName;
    private String chainClassification;
    private String pattern;
    private String defaultReferentRoleName;
    private ExpansionMode expansionMode;
    private FiliationType filiationType;
    private List<String> placeNames;
    private List<String> relationModelNames;
    private String alterRoleName;
    private List<RelationAttributeType> mainRelationAttributeTypes;
    private List<String> eventRoleNames;
    private List<String> labels;
    private int maxAge;
    private int minAge;
    private Geography geography;
    private boolean withEgoNetworks;
    private boolean withParcoursNetworks;
    private List<String> networkTitles;
    private String alterAttributeLabel;
    private String alterAttributeValue;

    public String getChainClassification() {
        return this.chainClassification;
    }

    public void setChainClassification(String chainClassification) {
        this.chainClassification = chainClassification;
    }

    public SequenceCensusCriteria(CensusType censusType) {
        this.censusType = censusType;
        this.relationAttributeType = RelationAttributeType.HOSTMIG;
        this.defaultReferentRoleName = "HOST";
        this.eventModelName = "Migevent";
        this.eventRoleNames = new ArrayList<String>();
        this.eventRoleNames.add("ALL");
        this.eventRoleNames.add("HOST");
        this.eventRoleNames.add("MIG");
        this.egoRoleName = "MIG";
        this.alterRoleName = "ALL";
        if (censusType == CensusType.PARCOURSNETWORKS) {
            this.alterAttributeLabel = "INTERV";
            this.alterAttributeValue = "Yes";
        }
        this.relationModelNames = new ArrayList<String>();
        this.relationModelNames.add("Apprenticeship");
        this.relationModelNames.add("Housing");
        this.relationModelNames.add("Employment");
        this.relationModelNames.add("Friendship");
        this.relationModelNames.add("Relatedness");
        this.minAge = 0;
        this.maxAge = 1000;
        this.relationAttributeTypes = new ArrayList<RelationAttributeType>();
        switch (censusType) {
            case GENERAL: {
                this.relationAttributeTypes.add(RelationAttributeType.PLACE);
                this.relationAttributeTypes.add(RelationAttributeType.MIGRATIONTYPE);
                this.relationAttributeTypes.add(RelationAttributeType.TREES);
                this.relationAttributeTypes.add(RelationAttributeType.CHILDMIGRATIONTYPE);
                this.relationAttributeTypes.add(RelationAttributeType.DISTANCE);
                this.relationAttributeTypes.add(RelationAttributeType.REGION);
                break;
            }
            case EGONETWORKS: {
                this.relationAttributeTypes.add(RelationAttributeType.PLACE);
                break;
            }
            case PARCOURSNETWORKS: {
                this.relationAttributeTypes.add(RelationAttributeType.PLACE);
                break;
            }
            case PARCOURS: {
                this.relationAttributeTypes.add(RelationAttributeType.PLACE);
            }
        }
        this.mainRelationAttributeTypes = new ArrayList<RelationAttributeType>();
        switch (censusType) {
            case GENERAL: {
                break;
            }
            case EGONETWORKS: {
                break;
            }
            case PARCOURSNETWORKS: {
                this.mainRelationAttributeTypes.add(RelationAttributeType.MIGRATIONTYPE);
                this.mainRelationAttributeTypes.add(RelationAttributeType.TYPEDID);
                break;
            }
            case PARCOURS: {
                this.mainRelationAttributeTypes.add(RelationAttributeType.PLACE);
                this.mainRelationAttributeTypes.add(RelationAttributeType.DISTANCE);
                this.mainRelationAttributeTypes.add(RelationAttributeType.TREES);
                this.mainRelationAttributeTypes.add(RelationAttributeType.MIGRATIONTYPE);
            }
        }
        for (RelationAttributeType mainEventType : this.mainRelationAttributeTypes) {
            if (this.relationAttributeTypes.contains((Object)mainEventType)) continue;
            this.relationAttributeTypes.add(mainEventType);
        }
        this.geography = Geography.getInstance();
        this.level = GeoLevel.TOWN;
        if (censusType == CensusType.GENERAL) {
            this.placeNames = Arrays.asList("Afagnan", "Lom\u00c8", "Bas-Mono", "Togo", "B\u00c8nin", "Ghana", "Nig\u00c8ria", "C\u00d9te d'Ivoire", "Afrique");
        }
        this.pattern = "3 1";
        this.chainClassification = "LINE";
        this.threshold = 0.01;
        this.splitLabel = "GENDER";
        this.networkTitles = new ArrayList<String>();
        this.partitionLabels = new HashMap<String, List<String>>();
        switch (censusType) {
            case GENERAL: {
                break;
            }
            case EGONETWORKS: {
                this.addNetworkTitle("Ego Network");
                this.addNetworkTitle("Nonmediated Ego Network");
                break;
            }
            case PARCOURSNETWORKS: {
                this.addNetworkTitle("Parcours");
                this.addNetworkTitle("Extended Parcours");
                this.addNetworkTitle("Multiple Parcours");
                for (RelationAttributeType mainEventType : this.mainRelationAttributeTypes) {
                    this.addNetworkTitle("Parcours Network_" + (Object)((Object)mainEventType));
                    this.addNetworkTitle("Parcours Similarity Tree_" + (Object)((Object)mainEventType));
                }
                break;
            }
            case PARCOURS: {
                this.addNetworkTitle("Event Type Network");
                this.addNetworkTitle("Sequence Type Network");
            }
        }
        for (String networkTitle : this.networkTitles) {
            this.partitionLabels.put(networkTitle, new ArrayList());
        }
        switch (censusType) {
            case GENERAL: {
                break;
            }
            case EGONETWORKS: {
                this.partitionLabels.get("Ego Network").add("EGO-RELATION");
                this.partitionLabels.get("Ego Network").add("DEGREE");
                this.partitionLabels.get("Nonmediated Ego Network").add("BETWEENNESS");
                this.partitionLabels.get("Nonmediated Ego Network").add("EGO-RELATION");
                this.partitionLabels.get("Nonmediated Ego Network").add("DEGREE");
                this.partitionLabels.get("Nonmediated Ego Network").add("COMPONENT");
                break;
            }
            case PARCOURSNETWORKS: {
                this.partitionLabels.get("Parcours").add("DATE");
                this.partitionLabels.get("Parcours").add("DISTANCE");
                this.partitionLabels.get("Multiple Parcours").add("DATE");
                this.partitionLabels.get("Multiple Parcours").add("DISTANCE");
                this.partitionLabels.get("Extended Parcours").add("ORDER");
                this.partitionLabels.get("Extended Parcours").add("TYPE");
                break;
            }
        }
        if (censusType == CensusType.PARCOURSNETWORKS) {
            for (RelationAttributeType mainEventType : this.mainRelationAttributeTypes) {
                List<String> egoNetworkPartitionLabels = this.partitionLabels.get("Parcours Network_" + (Object)((Object)mainEventType));
                egoNetworkPartitionLabels.add("BETWEENNESS");
                egoNetworkPartitionLabels.add("EGO-RELATION");
                egoNetworkPartitionLabels.add("DEGREE");
                egoNetworkPartitionLabels.add("COMPONENT");
                List<String> treePartitionLabels = this.partitionLabels.get("Parcours Similarity Tree_" + (Object)((Object)mainEventType));
                treePartitionLabels.add("SIZE");
                treePartitionLabels.add("STEP");
                treePartitionLabels.add("EGO-RELATION");
            }
        }
        this.labels = new ArrayList<String>();
        switch (censusType) {
            case GENERAL: {
                this.labels.add("NREVENTS");
                this.labels.add("NREXTERNALMOVES");
                this.labels.add("AGEFIRST");
                this.labels.add("AGEFIRST_CHILDMIGRATIONTYPE_NOPARENTS");
                this.labels.add("AGEFIRST_DISTANCE_TRANSNATIONAL");
                this.labels.add("MAX_DISTANCE");
                this.labels.add("SAMESEXALTERS_ALL");
                this.labels.add("SAMEPLACEALTERS_ALL");
                for (String roleName : this.eventRoleNames) {
                    this.labels.add("NRALTERS_" + roleName);
                    this.labels.add("NRALTERSPEREVENT_" + roleName);
                }
                for (RelationAttributeType type : this.relationAttributeTypes) {
                    this.labels.add("EVENTS_" + (Object)((Object)type));
                }
                this.labels.add("MEAN_COVERAGE");
                this.labels.add("MAX_COVERAGE");
                for (String roleName : this.eventRoleNames) {
                    this.labels.add("RELATIONS_" + roleName);
                }
                this.labels.add("MAIN_ALTERS");
                this.labels.add("MAIN_RELATIONS");
                break;
            }
            case EGONETWORKS: {
                this.labels.add("NREVENTS");
                this.labels.add("NREXTERNALMOVES");
                this.labels.add("SIZE");
                this.labels.add("TIES");
                this.labels.add("EGO-BETWEENNESS");
                this.labels.add("MEAN_BETWEENNESS");
                this.labels.add("MAX_BETWEENNESS");
                this.labels.add("ECCENTRICITY");
                this.labels.add("DENSITY");
                this.labels.add("DENSITY_NOLOOPS");
                this.labels.add("MEANDEGREE");
                this.labels.add("MEANDEGREE_NOLOOPS");
                this.labels.add("MEANDEGREE_NOLOOPS_NORM");
                this.labels.add("NRCOMPONENTS");
                this.labels.add("NRISOLATES");
                this.labels.add("MAXCOMPONENT");
                this.labels.add("NRCOMPONENTS_NORM");
                this.labels.add("NRISOLATES_NORM");
                this.labels.add("MAXCOMPONENT_NORM");
                this.labels.add("CONCENTRATION");
                this.labels.add("BROKERAGE");
                this.labels.add("EFFICIENT_SIZE");
                this.labels.add("EFFICIENCY");
                this.labels.add("NETWORK_RELATIONS");
                this.labels.add("CONNECTED_NETWORK_RELATIONS");
                this.labels.add("CENTRAL_ALTERS");
                this.labels.add("CENTRAL_RELATIONS");
                this.labels.add("SDENSITY_PARENT-CHILD");
                this.labels.add("SDENSITY_SPOUSE");
                this.labels.add("SDENSITY_SIBLING");
                this.labels.add("SDENSITY_RELATIVE");
                this.labels.add("SDENSITY_AFFINE");
                this.labels.add("SDENSITY_EMPLOYMENT");
                this.labels.add("SDENSITY_RENT");
                break;
            }
            case PARCOURSNETWORKS: {
                this.labels.add("NREVENTS");
                this.labels.add("NREXTERNALMOVES");
                for (RelationAttributeType mainEventType : this.mainRelationAttributeTypes) {
                    this.labels.add("SIZE_" + (Object)((Object)mainEventType));
                    this.labels.add("TIES_" + (Object)((Object)mainEventType));
                    this.labels.add("EGO-BETWEENNESS_" + (Object)((Object)mainEventType));
                    this.labels.add("MEAN_BETWEENNESS_" + (Object)((Object)mainEventType));
                    this.labels.add("MAX_BETWEENNESS_" + (Object)((Object)mainEventType));
                    this.labels.add("ECCENTRICITY_" + (Object)((Object)mainEventType));
                    this.labels.add("DENSITY_" + (Object)((Object)mainEventType));
                    this.labels.add("DENSITY_NOLOOPS_" + (Object)((Object)mainEventType));
                    this.labels.add("MEANDEGREE_" + (Object)((Object)mainEventType));
                    this.labels.add("MEANDEGREE_NOLOOPS_" + (Object)((Object)mainEventType));
                    this.labels.add("MEANDEGREE_NOLOOPS_NORM_" + (Object)((Object)mainEventType));
                    this.labels.add("NRCOMPONENTS_" + (Object)((Object)mainEventType));
                    this.labels.add("NRISOLATES_" + (Object)((Object)mainEventType));
                    this.labels.add("MAXCOMPONENT_" + (Object)((Object)mainEventType));
                    this.labels.add("NRCOMPONENTS_NORM_" + (Object)((Object)mainEventType));
                    this.labels.add("NRISOLATES_NORM_" + (Object)((Object)mainEventType));
                    this.labels.add("MAXCOMPONENT_NORM_" + (Object)((Object)mainEventType));
                    this.labels.add("CONCENTRATION_" + (Object)((Object)mainEventType));
                    this.labels.add("BROKERAGE_" + (Object)((Object)mainEventType));
                    this.labels.add("EFFICIENT_SIZE_" + (Object)((Object)mainEventType));
                    this.labels.add("EFFICIENCY_" + (Object)((Object)mainEventType));
                    this.labels.add("NETWORK_RELATIONS_" + (Object)((Object)mainEventType));
                    this.labels.add("CONNECTED_NETWORK_RELATIONS_" + (Object)((Object)mainEventType));
                    this.labels.add("SIMILARITY_" + (Object)((Object)mainEventType));
                }
                break;
            }
            case PARCOURS: {
                this.labels.add("NREVENTS");
                this.labels.add("NREXTERNALMOVES");
                for (RelationAttributeType relationAttributeType : this.mainRelationAttributeTypes) {
                    this.labels.add("PROFILE_" + (Object)((Object)relationAttributeType));
                    this.labels.add("SUPPORT_" + (Object)((Object)relationAttributeType));
                    if (relationAttributeType != RelationAttributeType.PLACE) continue;
                    this.labels.add("CENTERS_" + (Object)((Object)relationAttributeType));
                    this.labels.add("NRINTERNALMOVES_" + (Object)((Object)relationAttributeType));
                    this.labels.add("NRDIRECTRETURNS_" + (Object)((Object)relationAttributeType));
                    this.labels.add("NRCYCLES_" + (Object)((Object)relationAttributeType));
                    this.labels.add("NRDIRECTRETURNS_NORM_" + (Object)((Object)relationAttributeType));
                    this.labels.add("NRCYCLES_NORM_" + (Object)((Object)relationAttributeType));
                }
                break;
            }
        }
    }

    public SequenceCensusCriteria() {
        this.egoRoleName = "MIG";
        this.alterRoleName = "ALL";
        this.pattern = "3, 1";
        this.minAge = 0;
        this.maxAge = 1000;
        this.threshold = 0.01;
        this.level = GeoLevel.TOWN;
        this.splitLabel = "GENDER";
        this.eventModelName = "Migevent";
        this.relationModelNames = new ArrayList<String>();
        this.eventRoleNames = new ArrayList<String>();
        this.labels = new ArrayList<String>();
        this.networkTitles = new ArrayList<String>();
        this.eventRoleNames.add("ALL");
        this.relationAttributeTypes = new ArrayList<RelationAttributeType>();
        this.mainRelationAttributeTypes = new ArrayList<RelationAttributeType>();
        this.relationAttributeType = RelationAttributeType.HOSTMIG;
        this.geography = Geography.getInstance();
        this.partitionLabels = new HashMap<String, List<String>>();
        for (String networkTitle : this.networkTitles) {
            this.partitionLabels.put(networkTitle, new ArrayList());
        }
    }

    public void addNetworkTitle(String networkTitle) {
        this.networkTitles.add(networkTitle);
        this.partitionLabels.put(networkTitle, new ArrayList());
    }

    public void setType(RelationAttributeType type) {
        this.relationAttributeType = type;
    }

    public String getEgoRoleName() {
        return this.egoRoleName;
    }

    public void setEgoRoleName(String egoRoleName) {
        this.egoRoleName = egoRoleName;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMinAge() {
        return this.minAge;
    }

    public void setMinAge(int minAge) {
        this.minAge = minAge;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public String getRelationModelName() {
        return this.eventModelName;
    }

    public void setRelationModelName(String relationModelName) {
        this.eventModelName = relationModelName;
    }

    public GeoLevel getLevel() {
        return this.level;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public void setLevel(GeoLevel level) {
        this.level = level;
    }

    public String getPartitionLabel() {
        return this.splitLabel;
    }

    public void setPartitionLabel(String partitionLabel) {
        this.splitLabel = partitionLabel;
    }

    public List<String> getRelationModelNames() {
        return this.relationModelNames;
    }

    public String getAlterRoleName() {
        return this.alterRoleName;
    }

    public void setAlterRoleName(String alterRoleName) {
        this.alterRoleName = alterRoleName;
    }

    public Geography getGeography() {
        return this.geography;
    }

    public List<RelationAttributeType> getMainRelationAttributeTypes() {
        return this.mainRelationAttributeTypes;
    }

    public void setMainEventType(List<RelationAttributeType> mainEventTypes) {
        this.mainRelationAttributeTypes = mainEventTypes;
    }

    public void setGeography(Geography geography) {
        this.geography = geography;
    }

    public void setRelationModelNames(List<String> relationModelNames) {
        this.relationModelNames = relationModelNames;
    }

    public List<String> getRoleNames() {
        return this.eventRoleNames;
    }

    public void setRoleNames(List<String> alterRoleNames) {
        this.eventRoleNames = alterRoleNames;
    }

    public List<RelationAttributeType> getTypes() {
        return this.relationAttributeTypes;
    }

    public void setTypes(List<RelationAttributeType> types) {
        this.relationAttributeTypes = types;
    }

    public boolean isWithEgoNetworks() {
        return this.withEgoNetworks;
    }

    public void setWithEgoNetworks(boolean withEgoNetworks) {
        this.withEgoNetworks = withEgoNetworks;
    }

    public boolean isWithParcoursNetworks() {
        return this.withParcoursNetworks;
    }

    public void setWithParcoursNetworks(boolean withParcoursNetworks) {
        this.withParcoursNetworks = withParcoursNetworks;
    }

    public List<String> getNetworkTitles() {
        return this.networkTitles;
    }

    public String getAlterAttributeLabel() {
        return this.alterAttributeLabel;
    }

    public void setAlterAttributeLabel(String alterAttributeLabel) {
        this.alterAttributeLabel = alterAttributeLabel;
    }

    public String getAlterAttributeValue() {
        return this.alterAttributeValue;
    }

    public void setAlterAttributeValue(String alterAttributeValue) {
        this.alterAttributeValue = alterAttributeValue;
    }

    public Map<String, List<String>> getPartitionLabels() {
        return this.partitionLabels;
    }

    public List<String> getPlaceNames() {
        return this.placeNames;
    }

    public void setPlaceNames(List<String> placeNames) {
        this.placeNames = placeNames;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getDefaultReferentRoleName() {
        return this.defaultReferentRoleName;
    }

    public void setDefaultReferentRoleName(String defaultReferentRoleName) {
        this.defaultReferentRoleName = defaultReferentRoleName;
    }

    public void setCensusType(CensusType censusType) {
        this.censusType = censusType;
    }

    public CensusType getCensusType() {
        return this.censusType;
    }

    public List<RelationAttributeType> getEventTypes() {
        return this.relationAttributeTypes;
    }

    public void setEventTypes(List<RelationAttributeType> relationAttributeTypes) {
        this.relationAttributeTypes = relationAttributeTypes;
    }

    public ExpansionMode getExpansionMode() {
        return this.expansionMode;
    }

    public void setExpansionMode(ExpansionMode expansionMode) {
        this.expansionMode = expansionMode;
    }

    public FiliationType getFiliationType() {
        return this.filiationType;
    }

    public void setFiliationType(FiliationType filiationType) {
        this.filiationType = filiationType;
    }

    public static enum CensusType {
        GENERAL,
        EGONETWORKS,
        PARCOURSNETWORKS,
        PARCOURS;


        public String toString() {
            String result;
            switch (this) {
                case GENERAL: {
                    result = "General";
                    break;
                }
                case EGONETWORKS: {
                    result = "Ego Networks";
                    break;
                }
                case PARCOURSNETWORKS: {
                    result = "Parcours Networks";
                    break;
                }
                case PARCOURS: {
                    result = "Parcours";
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }
    }

    public static enum RelationAttributeType {
        TYPEDID,
        HOST,
        MIG,
        HOSTMIG,
        MIGRATIONTYPE,
        CHILDMIGRATIONTYPE,
        TREES,
        DISTANCE,
        PLACE,
        REGION,
        MOVEMENT,
        TURNOVER,
        COMPONENTS;

    }
}

