/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences;

import com.mysql.jdbc.StringUtils;
import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tip.puck.PuckException;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationWorker;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.sequences.Sequence;
import org.tip.puck.sequences.SequenceCensusCriteria;
import org.tip.puck.sequences.SequenceMaker;
import org.tip.puck.sequences.SequenceProfile;
import org.tip.puck.sequences.SequenceWorker;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Trafo;
import org.tip.puck.util.Value;

public class SequenceCensus {
    private Individual ego;
    private List<Relation> events;
    private String egoRoleName;
    private int[] maxDepths;
    private GeoLevel level;
    private List<String> placeNames;
    private List<String> relationModelNames;
    private List<String> roleNames;
    private List<SequenceCensusCriteria.RelationAttributeType> types;
    private String alterRoleName;
    private List<SequenceCensusCriteria.RelationAttributeType> mainEventTypes;
    private String relationModelName;
    private Geography geography;
    private List<Place> placeList;
    private String chainClassification;
    private String alterAttributeLabel;
    private String alterAttributeValue;
    private int length;
    private Map<String, Set<Individual>> altersByRoles;
    private Map<Individual, List<String>> rolesByAlter;
    private Map<Individual, List<String>> relationsByAlter;
    private Map<String, List<String>> relationsByRoles;
    private Map<Individual, List<Relation>> eventsByAlter;
    private Map<Integer, List<Individual>> coverage;
    private Map<SequenceCensusCriteria.RelationAttributeType, Map<Relation, String>> eventEvaluations;
    private Map<String, Double> specificDensities;
    private Map<String, GraphProfile<Individual>> networkProfiles;
    private Map<String, GraphProfile<Relation>> eventNetworkProfiles;
    private Map<String, List<String>> partitionLabels;
    private Map<SequenceCensusCriteria.RelationAttributeType, Graph<Set<Individual>>> parcoursSimilarityTrees;
    private Map<SequenceCensusCriteria.RelationAttributeType, SequenceProfile> sequenceProfiles;
    private String pattern;

    public SequenceCensus(Sequence source, SequenceCensusCriteria criteria) {
        this.ego = source.getEgo();
        this.events = new ArrayList<Relation>();
        this.length = 0;
        for (Relation event : source.getEvents().values()) {
            this.events.add(event);
            if (SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event)) continue;
            ++this.length;
        }
        this.egoRoleName = criteria.getEgoRoleName();
        this.pattern = criteria.getPattern();
        this.maxDepths = ToolBox.stringsToInts(criteria.getPattern());
        this.level = criteria.getLevel();
        this.partitionLabels = criteria.getPartitionLabels();
        this.relationModelName = criteria.getRelationModelName();
        this.relationModelNames = criteria.getRelationModelNames();
        this.alterRoleName = criteria.getAlterRoleName();
        this.geography = criteria.getGeography();
        this.roleNames = criteria.getRoleNames();
        this.types = criteria.getTypes();
        this.chainClassification = criteria.getChainClassification();
        this.alterAttributeLabel = criteria.getAlterAttributeLabel();
        this.alterAttributeValue = criteria.getAlterAttributeValue();
        this.mainEventTypes = criteria.getMainRelationAttributeTypes();
        this.placeNames = criteria.getPlaceNames();
        if (this.mainEventTypes.contains((Object)SequenceCensusCriteria.RelationAttributeType.TREES)) {
            for (Relation event : this.events) {
                event.updateReferents(criteria.getDefaultReferentRoleName());
            }
        }
        if ((this.types.contains((Object)SequenceCensusCriteria.RelationAttributeType.MIG) || this.types.contains((Object)SequenceCensusCriteria.RelationAttributeType.HOSTMIG) || this.types.contains((Object)SequenceCensusCriteria.RelationAttributeType.MIGRATIONTYPE) || this.types.contains((Object)SequenceCensusCriteria.RelationAttributeType.CHILDMIGRATIONTYPE)) && !this.roleNames.contains("MIG")) {
            this.roleNames.add("MIG");
        }
        if ((this.types.contains((Object)SequenceCensusCriteria.RelationAttributeType.HOST) || this.types.contains((Object)SequenceCensusCriteria.RelationAttributeType.HOSTMIG) || this.types.contains((Object)SequenceCensusCriteria.RelationAttributeType.MIGRATIONTYPE) || this.types.contains((Object)SequenceCensusCriteria.RelationAttributeType.CHILDMIGRATIONTYPE)) && !this.roleNames.contains("HOST")) {
            this.roleNames.add("HOST");
        }
        this.sequenceProfiles = new HashMap<SequenceCensusCriteria.RelationAttributeType, SequenceProfile>();
        this.networkProfiles = new HashMap<String, GraphProfile<Individual>>();
        this.eventNetworkProfiles = new HashMap<String, GraphProfile<Relation>>();
        this.setAlters();
        this.setAlterRelations("ALL");
        this.evaluateEvents();
        for (String networkTitle : criteria.getNetworkTitles()) {
            if (networkTitle.contains("Ego Network")) {
                this.setEgoNetworks();
                break;
            }
            if (!networkTitle.contains("Parcours Network")) continue;
            this.setParcoursNetworks();
            break;
        }
    }

    private void setEgoNetworks() {
        this.networkProfiles.put("Ego Network", new GraphProfile<Individual>(this.getEgoNetwork(), this.ego));
        this.networkProfiles.put("Nonmediated Ego Network", new GraphProfile<Individual>(this.getNonMediatedEgoNetwork(), this.ego));
        this.setSpecificDensities("Ego Network");
        this.setComponentTypes("Nonmediated Ego Network");
    }

    private List<String> getNetworkRelations(Graph<Individual> graph) {
        ArrayList<String> result = new ArrayList<String>();
        for (Node<Individual> node : graph.getNodes().toListSortedById()) {
            Individual referent = node.getReferent();
            for (String relation : this.relationsByAlter.get(referent)) {
                if (result.contains(relation)) continue;
                result.add(relation);
            }
        }
        Collections.sort(result);
        return result;
    }

    private List<String[]> getConnectedRelations(Partition<Node<Individual>> partition) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (Cluster<Node<Individual>> cluster : partition.getClusters()) {
            ArrayList<String> relations = new ArrayList<String>();
            for (Node<Individual> node : cluster.getItems()) {
                Individual referent = node.getReferent();
                for (String relation : this.relationsByAlter.get(referent)) {
                    if (relations.contains(relation)) continue;
                    relations.add(relation);
                }
            }
            Collections.sort(relations);
            for (String firstRelation : relations) {
                for (String secondRelation : relations) {
                    String[] pair;
                    if (firstRelation.equals(secondRelation) || result.contains(pair = new String[]{firstRelation, secondRelation})) continue;
                    result.add(pair);
                }
            }
        }
        return result;
    }

    private String getComponentType(Cluster<Node<Individual>> component) {
        String result = null;
        ArrayList relations = new ArrayList();
        for (Node<Individual> node : component.getItems()) {
            Individual referent = node.getReferent();
            relations.addAll(this.relationsByAlter.get(referent));
        }
        if (relations.contains("FATHER") && relations.contains("MOTHER")) {
            result = "PARENT";
        } else if (relations.contains("FATHER")) {
            result = "FATHER";
        } else if (relations.contains("MOTHER")) {
            result = "MOTHER";
        } else if (relations.contains("SPOUSE")) {
            result = "SPOUSE";
        } else {
            for (String relation : relations) {
                if (!relation.contains("RELATIVE")) continue;
                result = "RELATIVE";
                break;
            }
        }
        if (result == null) {
            result = relations.size() > 0 ? "OTHER" : "UNKNOWN";
        }
        return result;
    }

    private void setParcoursNetworks() {
        this.parcoursSimilarityTrees = new HashMap<SequenceCensusCriteria.RelationAttributeType, Graph<Set<Individual>>>();
        for (SequenceCensusCriteria.RelationAttributeType relationAttributeType : this.mainEventTypes) {
            this.networkProfiles.put("Parcours Network_" + (Object)((Object)relationAttributeType), new GraphProfile<Individual>(this.getParcoursNetwork(relationAttributeType), this.ego));
            if (!this.partitionLabels.get("Parcours Network_" + (Object)((Object)relationAttributeType)).contains("COMPONENT")) continue;
            this.setComponentTypes("Parcours Network_" + (Object)((Object)relationAttributeType));
        }
        this.eventNetworkProfiles.put("Parcours", new GraphProfile<Relation>(this.getParcoursGraph()));
        this.eventNetworkProfiles.put("Extended Parcours", new GraphProfile(this.getExtendedParcoursGraph()));
        this.eventNetworkProfiles.put("Multiple Parcours", new GraphProfile<Relation>(this.getMultipleParcoursGraph()));
    }

    private <E> void makeAlterRelationPartition(Graph<E> network) {
        for (Node<E> node : network.getNodes()) {
            E referent = node.getReferent();
            Individual alter = null;
            if (referent instanceof Individual) {
                alter = (Individual)referent;
            } else if (referent instanceof Set && ((Set)referent).size() == 1) {
                Iterator iterator = ((Set)referent).iterator();
                while (iterator.hasNext()) {
                    Individual element;
                    alter = element = (Individual)iterator.next();
                }
            }
            if (alter == null) continue;
            List<String> relations = this.relationsByAlter.get(alter);
            if (alter == this.ego) {
                node.setAttribute("EGO-RELATION", "EGO");
                continue;
            }
            if (relations == null) continue;
            node.setAttribute("EGO-RELATION", relations.toString());
        }
    }

    void writePajekNetwork(StringList pajekBuffer, String title) throws PuckException {
        Graph<Relation> network;
        if (title.contains("Parcours Similarity Tree")) {
            SequenceCensusCriteria.RelationAttributeType relationAttributeType = SequenceCensusCriteria.RelationAttributeType.valueOf(title.substring(title.lastIndexOf("_") + 1));
            Graph<Set<Individual>> network2 = this.parcoursSimilarityTrees.get((Object)relationAttributeType);
            this.makeAlterRelationPartition(network2);
            GraphUtils.getDepthPartition(network2);
            GraphUtils.addNodeLabelsFromPartition(network2, "EGO-RELATION");
            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(network2, this.partitionLabels.get(title)));
        } else if (title.contains("Network")) {
            Graph<Individual> network3 = this.networkProfiles.get(title).getGraph();
            this.makeAlterRelationPartition(network3);
            GraphUtils.addNodeLabelsFromPartition(network3, "EGO-RELATION");
            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(network3, this.partitionLabels.get(title)));
        } else if (title.contains("Parcours") && (network = this.eventNetworkProfiles.get(title).getGraph()).nodeCount() > 0) {
            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(network, this.partitionLabels.get(title)));
        }
    }

    private void setAlters() {
        this.altersByRoles = new HashMap<String, Set<Individual>>();
        this.altersByRoles.put("ALL", new HashSet());
        for (String alterRoleName : this.roleNames) {
            this.altersByRoles.put(alterRoleName, new HashSet());
        }
        this.rolesByAlter = new HashMap<Individual, List<String>>();
        this.eventsByAlter = new HashMap<Individual, List<Relation>>();
        this.coverage = new TreeMap<Integer, List<Individual>>();
        for (Relation event : this.events) {
            if (!event.hasRole(this.ego, this.egoRoleName) || SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event)) continue;
            for (Actor actor : event.actors()) {
                Individual alter = actor.getIndividual();
                String roleName = actor.getRole().getName();
                if (!this.altersByRoles.containsKey(roleName) || roleName.equals(this.egoRoleName) && alter == this.ego) continue;
                this.altersByRoles.get("ALL").add(alter);
                this.altersByRoles.get(actor.getRole().getName()).add(alter);
                List<String> roleNameList = this.rolesByAlter.get(alter);
                if (roleNameList == null) {
                    roleNameList = new ArrayList<String>();
                    this.rolesByAlter.put(alter, roleNameList);
                }
                roleNameList.add(roleName);
                List<Relation> eventList = this.eventsByAlter.get(alter);
                if (eventList == null) {
                    eventList = new ArrayList<Relation>();
                    this.eventsByAlter.put(alter, eventList);
                }
                if (eventList.contains(event)) continue;
                eventList.add(event);
            }
        }
        for (Individual alter : this.eventsByAlter.keySet()) {
            Integer cov = this.eventsByAlter.get(alter).size();
            List<Individual> list = this.coverage.get(cov);
            if (list == null) {
                list = new ArrayList<Individual>();
                this.coverage.put(cov, list);
            }
            if (list.contains(alter)) continue;
            list.add(alter);
        }
    }

    private void setAlterRelations(String alterRoleName) {
        this.relationsByAlter = NetUtils.getAlterRelations1(this.ego, this.altersByRoles.get(alterRoleName), this.maxDepths, this.relationModelNames, this.chainClassification, null);
        this.relationsByRoles = new HashMap<String, List<String>>();
        for (String roleName : this.altersByRoles.keySet()) {
            ArrayList<String> relations = new ArrayList<String>();
            this.relationsByRoles.put(roleName, relations);
            for (Individual alter : this.altersByRoles.get(roleName)) {
                if (this.relationsByAlter.get(alter).size() == 0) {
                    relations.add("UNKNOWN");
                    continue;
                }
                for (String relation : this.relationsByAlter.get(alter)) {
                    if (relations.contains(relation)) continue;
                    relations.add(relation);
                }
            }
        }
        KinType[] kinTypeArray = KinType.values();
        int n = kinTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KinType kinType = kinTypeArray[n2];
            for (Individual alter : this.ego.getKin(kinType)) {
                if (this.relationsByAlter.get(alter) != null) continue;
                ArrayList<String> list = new ArrayList<String>();
                list.add(kinType.toString());
                this.relationsByAlter.put(alter, list);
            }
            ++n2;
        }
    }

    private void setPlaceList() {
        this.placeList = new ArrayList<Place>();
        for (Relation relation : this.events) {
            Place place = this.geography.getPlace(relation.getAttributeValue("END_PLACE"), this.level);
            if (place == null) {
                place = new Place(this.level, "UNKNOWN");
            }
            this.placeList.add(place);
        }
    }

    private Relation getPreviousEvent(Relation event) {
        int index = this.events.indexOf(event) - 1;
        Relation result = index > -1 ? this.events.get(index) : null;
        return result;
    }

    private Double getTurnover(Relation event) {
        Double result = 0.0;
        Relation previousEvent = this.getPreviousEvent(event);
        if (previousEvent != null) {
            Individuals previousAlters = previousEvent.getIndividuals(this.roleNames);
            Individuals currentAlters = event.getIndividuals(this.roleNames);
            Double n = new Double(previousAlters.size());
            for (Individual individual : previousAlters) {
                if (!currentAlters.contains(individual)) continue;
                result = result + 1.0;
            }
            result = result / n;
        }
        return result;
    }

    private GeoLevel getMaxDistance() {
        GeoLevel result = null;
        for (Relation event : this.events) {
            String distance;
            if (SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event) || StringUtils.isNullOrEmpty((String)(distance = this.eventEvaluations.get((Object)SequenceCensusCriteria.RelationAttributeType.DISTANCE).get(event))) || distance.equals("UNDEFINED") || result != null && GeoLevel.valueOf(distance).compareTo(result) >= 0) continue;
            result = GeoLevel.valueOf(distance);
        }
        return result;
    }

    private List<String> getRelationTypes(Individuals alters) {
        ArrayList<String> result = new ArrayList<String>();
        for (Individual alter : alters) {
            if (this.relationsByAlter.get(alter) == null) continue;
            for (String relation : this.relationsByAlter.get(alter)) {
                if (result.contains(relation)) continue;
                result.add(relation);
            }
            if (result.size() != 0) continue;
            result.add("OTHER");
        }
        Collections.sort(result);
        return result;
    }

    private List<String> getRelationTypes(Relation event, String roleName) {
        Individuals alters = event.getIndividuals(roleName);
        if (roleName.equals("MIG")) {
            alters.removeById(this.ego.getId());
        }
        List<String> result = this.getRelationTypes(alters);
        return result;
    }

    private String getChildMigrationType(Relation event) {
        List<String> hosts = this.getRelationTypes(event, "HOST");
        List<String> migs = this.getRelationTypes(event, "MIG");
        String result = null;
        if (SequenceCensus.isBirth(event)) {
            result = "BIRTH";
        } else if (!(this.getAge(event) >= 16 || hosts.contains("FATHER") || hosts.contains("MOTHER") || migs.contains("FATHER") || migs.contains("MOTHER"))) {
            result = "NOPARENTS";
        }
        return result;
    }

    private String getMigrationType(Relation event) {
        String result;
        List<String> hosts = this.getRelationTypes(event, "HOST");
        List<String> migs = this.getRelationTypes(event, "MIG");
        if (SequenceCensus.isBirth(event)) {
            result = "BIRTH";
        } else if (SequenceCensus.isBirth(event)) {
            result = "DEATH";
        } else {
            int n;
            String hostType = "OTHER";
            if (hosts.size() == 0) {
                hostType = "NOBODY";
            } else {
                String[] types = new String[]{"EGO", "FATHER", "MOTHER", "SPOUSE", "CHILD", "SIBLING"};
                boolean end = false;
                String[] stringArray = types;
                n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    if (hosts.contains(type)) {
                        hostType = type;
                        end = true;
                        break;
                    }
                    ++n2;
                }
                if (!end && (hosts.contains("RELATIVE_AGNATIC") || hosts.contains("RELATIVE_UTERINE") || hosts.contains("RELATIVE_COGNATIC") || hosts.contains("RELATIVE"))) {
                    hostType = "KIN";
                } else if (!end && hosts.contains("AFFINE")) {
                    hostType = "AFFINE";
                }
            }
            String migType = "OTHER";
            if (migs.size() == 0) {
                migType = "NOBODY";
            } else {
                String[] types = new String[]{"EGO", "FATHER", "MOTHER", "SPOUSE", "CHILD", "SIBLING"};
                boolean end = false;
                String[] stringArray = types;
                int n3 = types.length;
                n = 0;
                while (n < n3) {
                    String type = stringArray[n];
                    if (migs.contains(type)) {
                        migType = type;
                        end = true;
                        break;
                    }
                    ++n;
                }
                if (!end && (migs.contains("RELATIVE_AGNATIC") || migs.contains("RELATIVE_UTERINE") || migs.contains("RELATIVE_COGNATIC") || migs.contains("RELATIVE"))) {
                    migType = "KIN";
                } else if (!end && migs.contains("AFFINE")) {
                    migType = "AFFINE";
                }
            }
            result = "WITH_" + migType + "_TO_" + hostType;
            result = result.replaceAll("WITH_NOBODY", "ALONE");
        }
        return result;
    }

    public static boolean isBirth(Relation event) {
        return event.getAttributeValue("END_PLACE") != null && event.getAttributeValue("START_PLACE") == null;
    }

    public static boolean isDeath(Relation event) {
        return event.getAttributeValue("END_PLACE") == null && event.getAttributeValue("START_PLACE") != null;
    }

    private Relation getFirstMigration() {
        Relation result = null;
        for (Relation event : this.events) {
            if (SequenceCensus.isBirth(event)) continue;
            if (SequenceCensus.isDeath(event)) break;
            result = event;
            break;
        }
        return result;
    }

    private Relation getFirstEvent(String label, String value) {
        Map<Relation, String> eventType = this.eventEvaluations.get((Object)SequenceCensusCriteria.RelationAttributeType.valueOf(label));
        Relation result = null;
        if (eventType != null) {
            for (Relation event : this.events) {
                if (!value.equals(eventType.get(event))) continue;
                result = event;
                break;
            }
        }
        return result;
    }

    private String getRelationTypesAsShortCutString(Relation event, String roleName) {
        String result = Trafo.asShortCutString(this.getRelationTypes(event, roleName), 2);
        if (result == null && roleName.equals("MIG")) {
            result = "SG";
        }
        return result;
    }

    private void evaluateEvents() {
        this.eventEvaluations = new HashMap<SequenceCensusCriteria.RelationAttributeType, Map<Relation, String>>();
        for (SequenceCensusCriteria.RelationAttributeType type : this.types) {
            this.eventEvaluations.put(type, new HashMap());
            if ((this.altersByRoles != null || type != SequenceCensusCriteria.RelationAttributeType.HOST && type != SequenceCensusCriteria.RelationAttributeType.MIG && type != SequenceCensusCriteria.RelationAttributeType.HOSTMIG && type != SequenceCensusCriteria.RelationAttributeType.MIGRATIONTYPE) && type == SequenceCensusCriteria.RelationAttributeType.MOVEMENT) {
                this.setPlaceList();
            }
            int i = 0;
            for (Relation event : this.events) {
                String eventType = null;
                switch (type) {
                    case TYPEDID: {
                        eventType = String.valueOf(event.getTypedId());
                        break;
                    }
                    case HOST: {
                        eventType = this.getRelationTypesAsShortCutString(event, "HOST");
                        break;
                    }
                    case MIG: {
                        eventType = this.getRelationTypesAsShortCutString(event, "MIG");
                        break;
                    }
                    case HOSTMIG: {
                        eventType = String.valueOf(this.getRelationTypesAsShortCutString(event, "HOST")) + ":" + this.getRelationTypesAsShortCutString(event, "MIG");
                        break;
                    }
                    case MIGRATIONTYPE: {
                        eventType = this.getMigrationType(event);
                        break;
                    }
                    case CHILDMIGRATIONTYPE: {
                        eventType = this.getChildMigrationType(event);
                        break;
                    }
                    case TREES: {
                        eventType = RelationWorker.getLinkTrees(event, true, "KIN", this.pattern);
                        break;
                    }
                    case DISTANCE: {
                        if (SequenceCensus.isBirth(event)) {
                            eventType = "BIRTH";
                            break;
                        }
                        if (SequenceCensus.isDeath(event)) {
                            eventType = "DEATH";
                            break;
                        }
                        GeoLevel distance = this.getDistance(event);
                        if (distance == null) break;
                        eventType = distance.dynamic().toString();
                        break;
                    }
                    case PLACE: {
                        if (SequenceCensus.isDeath(event)) {
                            eventType = "DEATH";
                            break;
                        }
                        Place place = this.geography.get(event.getAttributeValue("END_PLACE"), this.level);
                        if (place == null) break;
                        eventType = place.getName();
                        break;
                    }
                    case REGION: {
                        Place region = this.geography.getSup(event.getAttributeValue("END_PLACE"), this.placeNames);
                        if (region == null) break;
                        eventType = region.getName();
                        break;
                    }
                    case MOVEMENT: {
                        eventType = SequenceWorker.getMovement(this.placeList, i);
                        break;
                    }
                    case TURNOVER: {
                        eventType = String.valueOf(MathUtils.round(this.getTurnover(event), 2));
                        break;
                    }
                    default: {
                        eventType = null;
                    }
                }
                if (eventType == null) {
                    System.err.println("Event type " + (Object)((Object)type) + " is null for event " + event);
                    eventType = "UNDEFINED";
                }
                this.eventEvaluations.get((Object)type).put(event, eventType);
                ++i;
            }
        }
    }

    private GeoLevel getDistance(Relation event) {
        GeoLevel result = null;
        if (!SequenceCensus.isBirth(event) && !SequenceCensus.isDeath(event)) {
            Place start = this.geography.getByHomonym(event.getAttributeValue("START_PLACE"));
            Place end = this.geography.getByHomonym(event.getAttributeValue("END_PLACE"));
            if (start != null && end != null) {
                Place commonAncestor = this.geography.getCommonAncestor(start, end);
                result = commonAncestor.getLevel();
            }
        }
        return result;
    }

    public Graph getExtendedParcoursGraph() {
        Graph<Numberable> result = new Graph<Numberable>();
        result.setLabel("Extended Parcours " + this.ego);
        Relation lastEvent = null;
        for (Relation event : this.events) {
            if (lastEvent != null) {
                Link<Relation> eventLink = result.addArc(lastEvent, event, 2.0);
                eventLink.setTag(String.valueOf(this.ego.getId()));
                for (String label : this.roleNames) {
                    for (Individual alter : event.getIndividuals(label)) {
                        if (label == this.egoRoleName && alter == this.ego) continue;
                        Link<Individual> alterLink = result.addArc(event, alter, 1.0);
                        alterLink.setTag(label);
                    }
                }
            }
            lastEvent = event;
        }
        if (this.events.size() == 1) {
            result.addNode(lastEvent);
        }
        for (String label : this.roleNames) {
            Set<Individual> cluster = this.altersByRoles.get(label);
            if (cluster == null) continue;
            for (Individual alter : cluster) {
                for (Relation event : alter.relations().getByModel(lastEvent.getModel())) {
                    if (this.events.contains(event) || SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event) || Sequence.getYear(event) == null || Sequence.getYear(lastEvent) == null || Sequence.getYear(event) > Sequence.getYear(lastEvent)) continue;
                    for (Individual tertius : event.getIndividuals()) {
                        if (tertius.getId() <= alter.getId() || result.getNode(tertius) == null) continue;
                        Link<Individual> link1 = result.addArc(event, tertius, 1.0);
                        link1.setTag(event.getRoleNamesAsString(tertius));
                        Link<Individual> link2 = result.addArc(event, alter, 1.0);
                        link2.setTag(event.getRoleNamesAsString(alter));
                    }
                }
            }
        }
        int order = 1;
        for (Node obj : result.getNodes()) {
            Node node = obj;
            if (node.getReferent() instanceof Individual) {
                node.setAttribute("TYPE", "INDIVIDUAL");
                for (SequenceCensusCriteria.RelationAttributeType type : this.types) {
                    List<String> list = null;
                    list = type == SequenceCensusCriteria.RelationAttributeType.HOST || type == SequenceCensusCriteria.RelationAttributeType.MIG || type == SequenceCensusCriteria.RelationAttributeType.HOSTMIG ? this.relationsByAlter.get((Individual)node.getReferent()) : this.rolesByAlter.get((Individual)node.getReferent());
                    if (list == null) continue;
                    node.setAttribute(type.toString(), list.toString());
                }
                node.setAttribute("ORDER", "0");
                continue;
            }
            if (!(node.getReferent() instanceof Relation)) continue;
            node.setAttribute("TYPE", "EVENT");
            for (SequenceCensusCriteria.RelationAttributeType type : this.types) {
                String value = this.eventEvaluations.get((Object)type).get((Relation)node.getReferent());
                if (value == null) continue;
                node.setAttribute(type.toString(), value);
            }
            node.setAttribute("ORDER", String.valueOf(order));
            ++order;
        }
        return result;
    }

    public Value getValue(String label) {
        Value result = null;
        String parameter = null;
        if (label.contains("_")) {
            parameter = label.substring(label.lastIndexOf("_") + 1);
        }
        GraphProfile<Individual> networkProfile = null;
        if (this.networkProfiles != null && (networkProfile = this.networkProfiles.get("Nonmediated Ego Network")) == null) {
            networkProfile = this.networkProfiles.get("Parcours Network_" + parameter);
        }
        if (this.length == 0) {
            result = null;
        } else if (label.contains("PROFILE")) {
            SequenceProfile profile = this.getProfile(SequenceCensusCriteria.RelationAttributeType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getProfile());
        } else if (label.contains("SUPPORT")) {
            SequenceProfile profile = this.getProfile(SequenceCensusCriteria.RelationAttributeType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getSupportAsList());
        } else if (label.contains("CENTERS")) {
            SequenceProfile profile = this.getProfile(SequenceCensusCriteria.RelationAttributeType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getCentersAsList());
        } else if (label.contains("NRINTERNALMOVES")) {
            SequenceProfile profile = this.getProfile(SequenceCensusCriteria.RelationAttributeType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getNrLoops());
        } else if (label.contains("NREXTERNALMOVES")) {
            result = new Value(this.length - this.getValue("NRINTERNALMOVES_PLACE").intValue());
        } else if (label.contains("NRDIRECTRETURNS_NORM")) {
            result = Value.valueOf(MathUtils.percent(this.getValue("NRDIRECTRETURNS_" + parameter).intValue(), this.length));
        } else if (label.contains("NRDIRECTRETURNS")) {
            SequenceProfile profile = this.getProfile(SequenceCensusCriteria.RelationAttributeType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getNrDirectReturns());
        } else if (label.contains("NRCYCLES_NORM")) {
            result = Value.valueOf(MathUtils.percent(this.getValue("NRCYCLES_" + parameter).intValue(), this.length));
        } else if (label.contains("NRCYCLES")) {
            SequenceProfile profile = this.getProfile(SequenceCensusCriteria.RelationAttributeType.valueOf(parameter));
            result = profile == null ? null : Value.valueOf(profile.getNrCycles());
        } else if (label.contains("NRALTERSPEREVENT")) {
            result = new Value(this.getMeanNr(parameter));
        } else if (label.contains("AGEFIRST")) {
            String[] subLabels = label.split("_");
            Integer age = null;
            if (subLabels.length == 1) {
                age = this.getAge(this.getFirstMigration());
            } else if (subLabels.length == 3) {
                age = this.getAge(this.getFirstEvent(subLabels[1], subLabels[2]));
            }
            if (age != null) {
                result = new Value(age);
            }
        } else if (label.equals("MAX_DISTANCE")) {
            GeoLevel maxDistance = this.getMaxDistance();
            if (maxDistance != null) {
                result = new Value(maxDistance);
            }
        } else if (label.equals("MEAN_COVERAGE")) {
            result = this.length == 0 ? null : new Value(this.getMeanCoverage());
        } else if (label.equals("MAX_COVERAGE")) {
            result = this.length == 0 ? null : new Value(this.getMaxCoverage());
        } else if (label.contains("MEAN_BETWEENNESS")) {
            result = new Value(networkProfile.getMeanBetweenness());
        } else if (label.contains("MAX_BETWEENNESS")) {
            result = new Value(networkProfile.getMaxNonEgoBetweenness());
        } else if (label.equals("MAIN_ALTERS")) {
            result = new Value(this.getMaxCoverageAlters());
        } else if (label.contains("CENTRAL_ALTERS")) {
            result = networkProfile.nodeCount() < 3.0 ? null : new Value(networkProfile.getCentralAlters());
        } else if (label.equals("MAIN_RELATIONS")) {
            ArrayList<String> relations = new ArrayList<String>();
            for (Individual alter : this.getMaxCoverageAlters()) {
                for (String relation : this.relationsByAlter.get(alter)) {
                    if (relations.contains(relation)) continue;
                    relations.add(relation);
                }
            }
            result = new Value(relations);
        } else if (label.contains("EVENTS_")) {
            String typeName = label.substring(label.indexOf("_") + 1);
            ArrayList<String> types = new ArrayList<String>();
            for (Relation event : this.events) {
                String type = this.eventEvaluations.get((Object)SequenceCensusCriteria.RelationAttributeType.valueOf(typeName)).get(event);
                if (types.contains(type)) continue;
                types.add(type);
            }
            result = new Value(types);
        } else if (label.contains("CENTRAL_RELATIONS")) {
            if (networkProfile.nodeCount() < 3.0) {
                result = null;
            } else {
                ArrayList<String> relations = new ArrayList<String>();
                for (Individual alter : networkProfile.getCentralAlters()) {
                    for (String relation : this.relationsByAlter.get(alter)) {
                        if (relations.contains(relation)) continue;
                        relations.add(relation);
                    }
                }
                result = new Value(relations);
            }
        } else if (label.contains("CONNECTED_NETWORK_RELATIONS")) {
            result = new Value(this.getConnectedRelations(networkProfile.getNonEgoComponents()));
        } else if (label.contains("NETWORK_RELATIONS")) {
            result = new Value(this.getNetworkRelations(networkProfile.getGraphWithoutEgo()));
        } else if (label.contains("RELATIONS")) {
            result = new Value(this.relationsByRoles.get(parameter));
        } else if (label.equals("NREVENTS")) {
            result = new Value(this.length);
        } else if (label.contains("NRALTERS")) {
            result = new Value(this.altersByRoles.get(parameter).size());
        } else if (label.contains("SAMESEXALTERS")) {
            int sameSexAlters = 0;
            for (Individual alter : this.altersByRoles.get(parameter)) {
                if (alter.getGender() != this.ego.getGender()) continue;
                ++sameSexAlters;
            }
            result = this.altersByRoles.get(parameter).size() == 0 ? null : new Value(MathUtils.percent(sameSexAlters, this.altersByRoles.get(parameter).size()));
        } else if (label.contains("SAMEPLACEALTERS")) {
            int samePlaceAlters = 0;
            Place egoBirthPlace = this.geography.getPlace(this.ego.getAttributeValue("BIRT_PLAC"), this.level);
            for (Individual alter : this.altersByRoles.get(parameter)) {
                Place alterBirthPlace = this.geography.getPlace(alter.getAttributeValue("BIRT_PLAC"), this.level);
                if (egoBirthPlace == null || !egoBirthPlace.equals(alterBirthPlace)) continue;
                ++samePlaceAlters;
            }
            result = this.altersByRoles.get(parameter).size() == 0 ? null : new Value(MathUtils.percent(samePlaceAlters, this.altersByRoles.get(parameter).size()));
        } else if (label.contains("EGO-BETWEENNESS")) {
            result = new Value(networkProfile.getEgoBetweenness());
        } else if (label.contains("SIZE")) {
            result = new Value(networkProfile.nodeCount());
        } else if (label.contains("TIES")) {
            result = new Value(networkProfile.nonNullLineCount());
        } else if (label.contains("DENSITY")) {
            result = new Value(networkProfile.density());
        } else if (label.contains("DENSITY_NOLOOPS")) {
            result = new Value(networkProfile.densityWithoutLoops());
        } else if (label.contains("SDENSITY")) {
            result = this.specificDensities.get(parameter) == 0.0 ? null : new Value(this.specificDensities.get(parameter));
        } else if (label.contains("MEANDEGREE")) {
            result = new Value(networkProfile.meanDegree());
        } else if (label.contains("MEANDEGREE_NOLOOPS")) {
            result = new Value(networkProfile.meanDegreeWithoutLoops());
        } else if (label.contains("MEANDEGREE_NORM")) {
            result = new Value(networkProfile.meanDegreeNormalized());
        } else if (label.contains("MEANDEGREE_NOLOOPS_NORM")) {
            result = new Value(networkProfile.meanDegreeWithoutLoopsNormalized());
        } else if (label.contains("NRCOMPONENTS")) {
            result = new Value(networkProfile.getNonEgoComponents().size());
        } else if (label.contains("NRISOLATES")) {
            result = new Value(networkProfile.getNonEgoComponents().nrSingletons());
        } else if (label.contains("MAXCOMPONENT")) {
            result = new Value(networkProfile.getNonEgoComponents().maxClusterSize());
        } else if (label.contains("NRCOMPONENTS_NORM")) {
            result = networkProfile.getNonEgoComponents().size() == 0 ? null : new Value(networkProfile.getNonEgoComponents().meanShare());
        } else if (label.contains("MAXCOMPONENT_NORM")) {
            result = networkProfile.getNonEgoComponents().size() == 0 ? null : new Value(networkProfile.getNonEgoComponents().maxShare());
        } else if (label.contains("NRISOLATES_NORM")) {
            result = networkProfile.getNonEgoComponents().size() == 0 ? null : new Value(networkProfile.getNonEgoComponents().singletonShare());
        } else if (label.contains("BROKERAGE")) {
            result = new Value(networkProfile.brokerage());
        } else if (label.contains("EFFICIENT_SIZE")) {
            result = Value.valueOf(networkProfile.efficientSize());
        } else if (label.contains("EFFICIENCY")) {
            result = Value.valueOf(networkProfile.efficiency());
        } else if (label.contains("SIMILARITY")) {
            result = new Value(this.getParcoursSimilarities(SequenceCensusCriteria.RelationAttributeType.valueOf(parameter)));
        } else if (label.contains("ECCENTRICITY")) {
            result = new Value(networkProfile.getEccentricity());
        } else if (label.contains("CONCENTRATION")) {
            result = new Value(MathUtils.herfindahl(networkProfile.getNonEgoComponents().clusterSizes()));
        }
        return result;
    }

    private Integer getAge(Relation event) {
        Integer result = null;
        if (event != null) {
            int year = Sequence.getYear(event);
            result = IndividualValuator.ageAtYear(this.ego, year);
        }
        return result;
    }

    private double getMaxCoverage() {
        double result = this.coverage.size() > 0 ? MathUtils.percent((Integer)((TreeMap)this.coverage).lastKey(), this.length) : 0.0;
        return result;
    }

    private double getMeanCoverage() {
        double result = 0.0;
        if (this.coverage.size() > 0) {
            double sum = 0.0;
            for (int i : this.coverage.keySet()) {
                result += (double)i;
                sum += 1.0;
            }
            result = MathUtils.percent(result, sum * (double)this.length);
        }
        return result;
    }

    private void setSpecificDensities(String networkTitle) {
        Graph<Individual> network = this.networkProfiles.get(networkTitle).getGraph();
        this.specificDensities = new HashMap<String, Double>();
        this.specificDensities.put("PARENT-CHILD", 0.0);
        this.specificDensities.put("SPOUSE", 0.0);
        this.specificDensities.put("SIBLING", 0.0);
        this.specificDensities.put("RELATIVE", 0.0);
        this.specificDensities.put("AFFINE", 0.0);
        this.specificDensities.put("EMPLOYMENT", 0.0);
        this.specificDensities.put("RENT", 0.0);
        for (Link link : network.getLinks()) {
            String tag = link.getTag();
            tag = tag.substring(tag.indexOf("'") + 1, tag.lastIndexOf("'"));
            String key = null;
            if (tag.equals("FATHER") || tag.equals("MOTHER") || tag.equals("CHILD")) {
                key = "PARENT-CHILD";
            } else if (tag.equals("SPOUSE") || tag.equals("SIBLING") || tag.equals("AFFINE")) {
                key = tag;
            } else if (tag.contains("RELATIVE")) {
                key = "RELATIVE";
            } else if (tag.contains("EMPLOY")) {
                key = "EMPLOYMENT";
            } else if (tag.equals("LANDLORD") || tag.equals("LODGER")) {
                key = "RENT";
            }
            if (key == null) continue;
            this.specificDensities.put(key, this.specificDensities.get(key) + 1.0);
        }
        for (String string : this.specificDensities.keySet()) {
            this.specificDensities.put(string, MathUtils.percent(this.specificDensities.get(string), (double)network.lineCount()));
        }
    }

    private List<Individual> getMaxCoverageAlters() {
        List<Individual> result = this.coverage.size() > 1 ? this.coverage.get(((TreeMap)this.coverage).lastKey()) : new ArrayList<Individual>();
        return result;
    }

    private void setComponentTypes(String networkTitle) {
        Partition<Node<Individual>> nonEgoComponents = this.networkProfiles.get(networkTitle).getNonEgoComponents();
        if (nonEgoComponents.size() > 0) {
            for (Cluster<Node<Individual>> component : nonEgoComponents.getClusters().toList()) {
                String type = this.getComponentType(component);
                Value value = new Value(type);
                if (nonEgoComponents.getValues().contains(value)) {
                    int i = 1;
                    while (nonEgoComponents.getValues().contains(value)) {
                        value = new Value(String.valueOf(type) + " " + ++i);
                    }
                }
                nonEgoComponents.changeClusterValue(component, value);
            }
        }
    }

    private double getMeanNr(String roleName) {
        double result = MathUtils.percent(this.altersByRoles.get(roleName).size(), 100 * this.length);
        return result;
    }

    private Graph<Individual> getEgoNetwork() {
        Graph<Individual> result = new Graph<Individual>("Ego network " + this.ego + " " + this.relationModelName + " " + this.egoRoleName + "-" + this.alterRoleName);
        HashMap<String, Integer> tagMap = new HashMap<String, Integer>();
        result.addNode(this.ego);
        for (Individual alter : this.altersByRoles.get(this.alterRoleName)) {
            result.addNode(alter);
        }
        List referents = result.getReferents();
        int i = 0;
        while (i < referents.size()) {
            Individual ego = (Individual)referents.get(i);
            int j = 0;
            while (j < i) {
                Individual alter = (Individual)referents.get(j);
                for (String tag : NetUtils.getAlterRoles(ego, alter, this.maxDepths, this.relationModelNames, this.chainClassification)) {
                    Link<Individual> link = result.addArc(ego, alter, 1.0);
                    Integer tagNumber = (Integer)tagMap.get(tag);
                    if (tagNumber == null) {
                        tagNumber = tagMap.size() + 1;
                        tagMap.put(tag, tagNumber);
                    }
                    link.setTag(":" + tagNumber + " '" + tag + "'");
                }
                ++j;
            }
            ++i;
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    private Graph<Relation> getParcoursGraph() {
        Graph<Relation> result = new Graph<Relation>();
        result.setLabel("Parcours " + this.ego);
        Relation previousEvent = null;
        for (Relation event : this.events) {
            if (previousEvent != null) {
                Link<Relation> link = result.addArc(previousEvent, event, 1.0);
                link.setTag(String.valueOf(this.ego.getId()));
            }
            previousEvent = event;
        }
        if (this.events.size() == 1) {
            result.addNode(previousEvent);
        }
        return result;
    }

    private Graph<Relation> getMultipleParcoursGraph() {
        ArrayList<Graph<Graph<Relation>>> graphs = new ArrayList<Graph<Graph<Relation>>>();
        SequenceCensusCriteria criteria = new SequenceCensusCriteria();
        criteria.setMaxAge(1000);
        criteria.setRelationModelNames(this.relationModelNames);
        criteria.setRelationModelName(this.relationModelName);
        for (Individual alter : this.altersByRoles.get(this.alterRoleName)) {
            Sequence fullBiography = SequenceMaker.createPersonalSequence(alter, criteria);
            Sequence sortedBiography = (Sequence)SequenceWorker.sortAndSplit(fullBiography).getById(1);
            SequenceCensus census = new SequenceCensus(sortedBiography, criteria);
            if (sortedBiography.getNrEvents() <= 0) continue;
            Graph<Relation> alterGraph = census.getParcoursGraph();
            graphs.add(alterGraph);
        }
        Graph<Relation> result = GraphUtils.fuse(graphs);
        result.setLabel("Multiple parcours " + this.ego);
        return result;
    }

    private Graph<Individual> getParcoursNetwork(SequenceCensusCriteria.RelationAttributeType relationAttributeType) {
        String value;
        Graph<Individual> result = new Graph<Individual>("Parcours Network_" + (Object)((Object)relationAttributeType) + " " + this.ego + " " + this.relationModelName + " " + this.egoRoleName + "-" + this.alterRoleName);
        result.addNode(this.ego);
        for (Individual alter : this.altersByRoles.get(this.alterRoleName)) {
            value = alter.getAttributeValue(this.alterAttributeLabel);
            if (value == null || !value.equals(this.alterAttributeValue)) continue;
            result.addNode(alter);
        }
        for (Individual alter : this.ego.getKin()) {
            value = alter.getAttributeValue(this.alterAttributeLabel);
            if (value == null || !value.equals(this.alterAttributeValue)) continue;
            result.addNode(alter);
        }
        List referents = result.getReferents();
        HashMap<Individual, Set<String>> typeMap = new HashMap<Individual, Set<String>>();
        SequenceCensusCriteria criteria = new SequenceCensusCriteria();
        criteria.setMaxAge(1000);
        criteria.setRelationModelNames(this.relationModelNames);
        criteria.setRelationModelName(this.relationModelName);
        criteria.setChainClassification(this.chainClassification);
        criteria.setPattern(this.pattern);
        criteria.getTypes().addAll(this.types);
        for (Individual alter : referents) {
            Sequence fullBiography = SequenceMaker.createPersonalSequence(alter, criteria);
            Sequence sortedBiography = (Sequence)SequenceWorker.sortAndSplit(fullBiography).getById(1);
            SequenceCensus census = new SequenceCensus(sortedBiography, criteria);
            typeMap.put(alter, census.getProfile(relationAttributeType).getSupport());
        }
        double[][] distanceMatrix = new double[referents.size()][referents.size()];
        int i = 0;
        while (i < referents.size()) {
            Individual first = (Individual)referents.get(i);
            int j = 0;
            while (j < i) {
                Individual second = (Individual)referents.get(j);
                double[] shares = MathUtils.intersectionRates((Collection)typeMap.get(first), (Collection)typeMap.get(second));
                result.addArc(first, second, shares[0]);
                result.addArc(second, first, shares[1]);
                distanceMatrix[i][j] = 100.0 - shares[2];
                distanceMatrix[j][i] = distanceMatrix[i][j];
                ++j;
            }
            ++i;
        }
        this.parcoursSimilarityTrees.put(relationAttributeType, GraphUtils.createPhylogeneticTree(this.ego, "Parcours similarity tree_" + (Object)((Object)relationAttributeType) + "_" + this.ego, referents, distanceMatrix));
        NetUtils.setGenderShapes(result);
        return result;
    }

    public Partition<Link<Individual>> getParcoursLinkPartition(SequenceCensusCriteria.RelationAttributeType relationAttributeType) {
        GraphProfile<Individual> parcoursNetworkProfile = this.networkProfiles.get("Parcours Network_" + (Object)((Object)relationAttributeType));
        Partition result = parcoursNetworkProfile.getLinkPartition();
        if (result == null) {
            result = GraphUtils.getLinkPartitionByKinship(parcoursNetworkProfile.getGraph());
            parcoursNetworkProfile.setLinkPartition(result);
        }
        return result;
    }

    public Map<Value, Double[]> getParcoursSimilarities(SequenceCensusCriteria.RelationAttributeType relationAttributeType) {
        GraphProfile<Individual> parcoursNetworkProfile = this.networkProfiles.get("Parcours Network_" + (Object)((Object)relationAttributeType));
        if (parcoursNetworkProfile.getLinkPartition() == null) {
            parcoursNetworkProfile.setLinkPartition(GraphUtils.getLinkPartitionByKinship(parcoursNetworkProfile.getGraph()));
        }
        Map<Value, Double[]> result = parcoursNetworkProfile.aggregateWeights();
        return result;
    }

    private Graph<Individual> getNonMediatedEgoNetwork() {
        Graph<Individual> result = new Graph<Individual>("Nonmediated Ego Network " + this.ego + " " + this.relationModelName + " " + this.egoRoleName + "-" + this.alterRoleName);
        HashMap<String, Integer> tagMap = new HashMap<String, Integer>();
        result.addNode(this.ego);
        for (Individual alter : this.altersByRoles.get(this.alterRoleName)) {
            result.addNode(alter);
        }
        List<Individual> referents = result.getReferents();
        int i = 0;
        while (i < referents.size()) {
            Individual ego = (Individual)referents.get(i);
            int j = 0;
            while (j < i) {
                Individual alter = (Individual)referents.get(j);
                for (String tag : NetUtils.getAlterRoles(ego, alter, this.maxDepths, this.relationModelNames, this.chainClassification, referents)) {
                    Link<Individual> link = result.addArc(ego, alter, 1.0);
                    Integer tagNumber = (Integer)tagMap.get(tag);
                    if (tagNumber == null) {
                        tagNumber = tagMap.size() + 1;
                        tagMap.put(tag, tagNumber);
                    }
                    link.setTag(":" + tagNumber + " '" + tag + "'");
                }
                ++j;
            }
            ++i;
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    Partition<Node<Individual>> getComponents(String networkTitle) {
        return this.networkProfiles.get(networkTitle).getNonEgoComponents();
    }

    private SequenceProfile getProfile(SequenceCensusCriteria.RelationAttributeType relationAttributeType) {
        SequenceProfile result = this.sequenceProfiles.get((Object)relationAttributeType);
        if (result == null) {
            result = new SequenceProfile(this.events, this.eventEvaluations, relationAttributeType);
            this.sequenceProfiles.put(relationAttributeType, result);
        }
        return result;
    }

    public static String getEgoRolePartners(Relation event, SequenceCensusCriteria criteria) {
        String result = "";
        if (event.getModel().getName().equals(criteria.getRelationModelName())) {
            result = event.getIndividuals(criteria.getEgoRoleName()).toStringAsNameList();
        }
        return result;
    }
}

