/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.Places;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.report.ReportTable;
import org.tip.puck.sequences.Ordinal;
import org.tip.puck.sequences.SequenceWorker;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.Trafo;
import org.tip.puck.util.Value;

public class Sequence
implements Comparable<Sequence>,
Numberable {
    int id;
    Map<Ordinal, Relation> events;
    Individual ego;
    String egoRoleName;
    Partition<Individual> alters;
    Map<Individual, String> alterRelations;
    Map<Relation, String> eventTypes;

    public Individual getEgo() {
        return this.ego;
    }

    public void setEgo(Individual ego) {
        this.ego = ego;
    }

    public String getEgoRoleName() {
        return this.egoRoleName;
    }

    public void setEgoRoleName(String egoRoleName) {
        this.egoRoleName = egoRoleName;
    }

    public Sequence(int id) {
        this.id = id;
        this.events = new TreeMap<Ordinal, Relation>();
    }

    public Ordinal getNext(Ordinal key) {
        Ordinal result = key != null ? ((TreeMap)this.events).higherKey(key) : null;
        return result;
    }

    public Ordinal getNextFree(Ordinal key, Set<Ordinal> filter) {
        Ordinal result;
        if (key != null) {
            result = ((TreeMap)this.events).higherKey(key);
            if (result != null && filter.contains(result)) {
                result = this.getNextFree(result, filter);
            }
        } else {
            result = null;
        }
        return result;
    }

    public Ordinal getFirst() {
        Ordinal result = (Ordinal)((TreeMap)this.events).firstKey();
        return result;
    }

    public Roles getRoles() {
        Roles result = new Roles();
        for (Relation relation : this.events.values()) {
            for (Actor actor : relation.actors()) {
                if (result.contains(actor.getRole())) continue;
                result.add(actor.getRole());
            }
        }
        return result;
    }

    public Individuals individuals() {
        Individuals result = new Individuals();
        for (Relation relation : this.events.values()) {
            for (Actor actor : relation.actors()) {
                if (result.contains(actor.getIndividual())) continue;
                result.add(actor.getIndividual());
            }
        }
        return result;
    }

    public Graph getExtendedParcoursGraph(Geography geography) {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("HOST");
        labels.add("MIG");
        Graph<Numberable> result = new Graph<Numberable>();
        result.setLabel("Extended Parcours " + this.ego);
        Relation lastEvent = null;
        for (Relation event : this.events.values()) {
            if (lastEvent != null) {
                Link<Relation> eventLink = result.addArc(lastEvent, event, 2.0);
                eventLink.setTag(String.valueOf(this.ego.getId()));
                for (String label : labels) {
                    for (Individual alter : event.getIndividuals(label)) {
                        if (label == this.egoRoleName && alter == this.ego) continue;
                        Link<Individual> alterLink = result.addArc(event, alter, 1.0);
                        alterLink.setTag(label);
                    }
                }
            }
            lastEvent = event;
        }
        if (this.events.size() == 1) {
            result.addNode(lastEvent);
        }
        for (String label : labels) {
            Cluster<Individual> cluster = this.alters.getCluster(new Value(label));
            if (cluster == null) continue;
            for (Individual alter : cluster.getItems()) {
                for (Relation event : alter.relations().getByModel(lastEvent.getModel())) {
                    if (this.getEvents().containsValue(event) || event.getAttributeValue("START_PLACE") == null || Sequence.getYear(event) == null || Sequence.getYear(lastEvent) == null || Sequence.getYear(event) > Sequence.getYear(lastEvent)) continue;
                    for (Individual tertius : event.getIndividuals()) {
                        if (tertius.getId() <= alter.getId() || result.getNode(tertius) == null) continue;
                        Link<Individual> link1 = result.addArc(event, tertius, 1.0);
                        link1.setTag(event.getRoleNamesAsString(tertius));
                        Link<Individual> link2 = result.addArc(event, alter, 1.0);
                        link2.setTag(event.getRoleNamesAsString(alter));
                    }
                }
            }
        }
        int order = 1;
        for (Node obj : result.getNodes()) {
            Node node = obj;
            if (node.getReferent() instanceof Individual) {
                node.setAttribute("TYPE", "INDIVIDUAL");
                Value roleNames = this.alters.getValue((Individual)node.getReferent());
                node.setAttribute("MOVEMENT", roleNames.toString());
                node.setAttribute("RELATIONS", this.alterRelations.get((Individual)node.getReferent()));
                node.setAttribute("ORDER", "0");
                continue;
            }
            if (!(node.getReferent() instanceof Relation)) continue;
            node.setAttribute("TYPE", "EVENT");
            GeoLevel distance = Sequence.getDistance(geography, (Relation)node.getReferent());
            String type = this.getEventType((Relation)node.getReferent());
            if (distance != null) {
                node.setAttribute("MOVEMENT", distance.toString());
            }
            if (type != null) {
                node.setAttribute("RELATIONS", type);
            }
            node.setAttribute("ORDER", String.valueOf(order));
            ++order;
        }
        return result;
    }

    public Partition<Individual> alterRelations(String alterRoleName) {
        Partition<Individual> result = new Partition<Individual>();
        List<Individual> individuals = alterRoleName.equals("ALL") ? this.alters.getItemsAsList() : this.alters(alterRoleName);
        for (Individual alter : individuals) {
            result.put(alter, new Value(this.alterRelations.get(alter)));
        }
        return result;
    }

    public void setAlters() {
        this.alters = new Partition();
        for (Relation event : this.events.values()) {
            if (!event.hasRole(this.ego, this.egoRoleName) || event.getAttributeValue("START_PLACE") == null) continue;
            for (Actor actor : event.actors()) {
                if (actor.getRole().getName().equals(this.egoRoleName) && actor.getIndividual() == this.ego) continue;
                Value value = this.alters.getValue(actor.getIndividual());
                if (value == null) {
                    this.alters.put(actor.getIndividual(), new Value(actor.getRole().getName()));
                    continue;
                }
                this.alters.put(actor.getIndividual(), new Value(String.valueOf(value.toString()) + " " + actor.getRole().getName()));
            }
        }
    }

    public void setAlterRelations(int[] maxDegree, List<String> relationModelNames) {
        this.alterRelations = NetUtils.getAlterRelations(this.ego, this.alters(), maxDegree, relationModelNames);
    }

    public List<Individual> alters(String alterRoleName) {
        Cluster<Individual> cluster = this.alters.getCluster(new Value(alterRoleName));
        List<Individual> result = cluster != null ? cluster.getItems() : new ArrayList<Individual>();
        return result;
    }

    public List<Individual> alters() {
        List<Individual> result = this.alters.getItemsAsList();
        return result;
    }

    public Relation getEvent(Ordinal order) {
        Relation result = order != null ? this.events.get(order) : null;
        return result;
    }

    public static Integer getYear(Relation event) {
        Integer result = null;
        if (event != null) {
            result = IndividualValuator.extractYearAsInt(event.getAttributeValue("DATE"));
        }
        return result;
    }

    public Integer getAge(Integer year) {
        Integer result = year != null ? IndividualValuator.ageAtYear(this.ego, year) : null;
        return result;
    }

    public Integer getAge(Relation event) {
        Integer result = null;
        if (event != null) {
            int year = Sequence.getYear(event);
            result = IndividualValuator.ageAtYear(this.ego, year);
        }
        return result;
    }

    public static GeoLevel getDistance(Geography geography, Relation event) {
        GeoLevel result = null;
        if (event.getAttributeValue("START_PLACE") != null && event.getAttributeValue("END_PLACE") != null) {
            Place start = geography.getByHomonym(event.getAttributeValue("START_PLACE"));
            Place end = geography.getByHomonym(event.getAttributeValue("END_PLACE"));
            if (start != null && end != null) {
                Place commonAncestor = geography.getCommonAncestor(start, end);
                result = commonAncestor.getLevel();
            }
        }
        return result;
    }

    public boolean isMigration(Relation event) {
        boolean result = event.getRoleNames(this.ego).contains("MIG") && event.getAttributeValue("START_PLACE") != null && event.getAttributeValue("END_PLACE") != null;
        return result;
    }

    public boolean isEarlyMigration(Relation event, int ageLimit) {
        Integer age = this.getAge(event);
        boolean result = this.isMigration(event) && age != null && age < ageLimit;
        return result;
    }

    public boolean isMigrationToParent(Relation event) {
        Individuals hosts = event.getIndividuals("HOST");
        boolean result = this.isMigration(event) && (hosts.contains(this.ego.getFather()) || hosts.contains(this.ego.getMother()));
        return result;
    }

    public boolean isMigrationToNonParent(Relation event) {
        boolean result = this.isMigration(event) && !this.isMigrationToParent(event);
        return result;
    }

    public boolean isMigrationWithParent(Relation event) {
        Individuals company = event.getIndividuals("MIG");
        boolean result = this.isMigration(event) && (company.contains(this.ego.getFather()) || company.contains(this.ego.getMother()));
        return result;
    }

    public boolean isMigrationWithoutParent(Relation event) {
        boolean result = this.isMigration(event) && !this.isMigrationWithParent(event);
        return result;
    }

    public boolean isMigrationWithSpouse(Relation event) {
        boolean result = false;
        if (this.isMigration(event)) {
            Individuals company = event.getIndividuals("MIG");
            for (Individual spouse : this.ego.getSpousesAt(Sequence.getYear(event))) {
                if (!company.contains(spouse)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isMigrationWithoutSpouse(Relation event) {
        boolean result = this.isMigration(event) && this.ego.getSpousesAt(Sequence.getYear(event)).size() > 0 && !this.isMigrationWithSpouse(event);
        return result;
    }

    public boolean isMigrationToNonSpouse(Relation event) {
        boolean result = this.isMigration(event) && this.ego.getSpousesAt(Sequence.getYear(event)).size() > 0 && !this.isMigrationToSpouse(event);
        return result;
    }

    public boolean isMigrationToSpouse(Relation event) {
        boolean result = false;
        if (this.isMigration(event)) {
            Individuals hosts = event.getIndividuals("HOST");
            for (Individual spouse : this.ego.getSpousesAt(Sequence.getYear(event))) {
                if (!hosts.contains(spouse)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public List<String> getRelationTypes(Individuals alters) {
        ArrayList<String> result = new ArrayList<String>();
        for (Individual alter : alters) {
            String relation = this.alterRelations.get(alter);
            if (result.contains(relation)) continue;
            result.add(relation);
        }
        Collections.sort(result);
        return result;
    }

    public String getType(Relation event, String roleName) {
        String result;
        Individuals alters = event.getIndividuals(roleName);
        if (roleName.equals("MIG")) {
            alters.removeById(this.ego.getId());
        }
        if ((result = Trafo.asShortCutString(this.getRelationTypes(alters), 1)) == null) {
            result = roleName.equals("MIG") ? "SINGLE" : "NONE";
        }
        return result;
    }

    public String getEventTypePattern() {
        String result = "";
        boolean first = true;
        for (Relation event : this.getEvents().values()) {
            if (first) {
                result = String.valueOf(result) + this.getEventType(event);
                first = false;
                continue;
            }
            result = String.valueOf(result) + ";" + this.getEventType(event);
        }
        return result;
    }

    public List<String> getEventTypesAsSortedList() {
        ArrayList<String> result = new ArrayList<String>();
        for (String type : this.eventTypes.values()) {
            if (result.contains(type)) continue;
            result.add(type);
        }
        Collections.sort(result);
        return result;
    }

    public String getEventTypesAsString() {
        String result = "";
        boolean first = true;
        List<String> list = this.getEventTypesAsSortedList();
        if (this.eventTypes != null) {
            for (String type : list) {
                if (first) {
                    result = String.valueOf(result) + type;
                    first = false;
                    continue;
                }
                result = String.valueOf(result) + ";" + type;
            }
        }
        return result;
    }

    public int getNrEvents() {
        return this.events.size();
    }

    public int getNrEventTypes() {
        int result = this.eventTypes != null ? this.getEventTypesAsSortedList().size() : 0;
        return result;
    }

    public String getEventType(Relation event) {
        String result = this.eventTypes.get(event);
        return result;
    }

    public Partition<Relation> getEventTypes() {
        Partition<Relation> result = new Partition<Relation>();
        for (Relation event : this.events.values()) {
            result.put(event, new Value(this.getEventType(event)));
        }
        return result;
    }

    public Relations childMigrationsWithoutParents() {
        Relations result = new Relations();
        for (Relation event : this.events.values()) {
            Integer age = this.getAge(event);
            if (!(age == null || age >= 18 || !event.getRoleNames(this.ego).contains("MIG") || event.getAttributeValue("START_PLACE") == null || event.getAttributeValue("END_PLACE") == null || event.getIndividuals("MIG").contains(this.ego.getFather()) || event.getIndividuals("MIG").contains(this.ego.getMother()) || event.getIndividuals("HOST").contains(this.ego.getFather()) || event.getIndividuals("HOST").contains(this.ego.getMother()))) {
                result.add(event);
                continue;
            }
            if (age != null && age >= 18) break;
        }
        return result;
    }

    public ReportTable roleTable() {
        Individuals individuals = this.individuals();
        ReportTable result = new ReportTable(this.events.size() + 1, individuals.size() + 1);
        result.set(0, 0, this.id);
        int columnIndex = 1;
        for (Individual individual : individuals) {
            result.set(0, columnIndex, individual.getName());
            ++columnIndex;
        }
        int rowIndex = 1;
        for (Ordinal eventOrder : this.events.keySet()) {
            result.set(rowIndex, 0, eventOrder);
            columnIndex = 1;
            Relation event = this.events.get(eventOrder);
            for (Individual individual : individuals) {
                String rolesAsString = " - ";
                Roles roles = event.actors().getRoles(individual.getId());
                if (roles != null && roles.size() > 0) {
                    rolesAsString = roles.nameList().toString();
                }
                result.set(rowIndex, columnIndex, rolesAsString);
                ++columnIndex;
            }
            ++rowIndex;
        }
        return result;
    }

    public ReportTable interactionTable() {
        Individuals individuals = this.individuals();
        ReportTable result = new ReportTable(individuals.size() + 1, individuals.size() + 1);
        result.set(0, 0, this.id);
        int columnIndex = 1;
        for (Individual individual : individuals) {
            result.set(0, columnIndex, individual.getName());
            ++columnIndex;
        }
        int rowIndex = 1;
        for (Individual individual1 : individuals) {
            result.set(rowIndex, 0, individual1.getName());
            columnIndex = 1;
            for (Individual individual2 : individuals) {
                if (columnIndex >= rowIndex) break;
                String roles1AsString = "";
                String roles2AsString = "";
                for (Ordinal eventOrder : this.events.keySet()) {
                    Relation event = this.events.get(eventOrder);
                    Roles roles1 = event.actors().getRoles(individual1.getId());
                    Roles roles2 = event.actors().getRoles(individual2.getId());
                    if (roles1 == null || roles1.size() <= 0 || roles2 == null || roles2.size() <= 0) continue;
                    roles1AsString = String.valueOf(roles1AsString) + roles1.nameList().toString();
                    roles2AsString = String.valueOf(roles2AsString) + roles2.nameList().toString();
                }
                result.set(rowIndex, columnIndex, roles1AsString);
                result.set(columnIndex, rowIndex, roles2AsString);
                ++columnIndex;
            }
            ++rowIndex;
        }
        return result;
    }

    public void put(Ordinal order, Relation relation) {
        this.events.put(order, relation);
    }

    public Sequence clone() {
        Sequence result = new Sequence(this.id);
        result.setEgo(this.ego);
        result.setEgoRoleName(this.egoRoleName);
        for (Ordinal key : this.events.keySet()) {
            result.put(key, this.getEvent(key));
        }
        return result;
    }

    public List<Relation> toList() {
        ArrayList<Relation> result = new ArrayList<Relation>(this.events.values());
        return result;
    }

    public Places getPlaceSequence(Geography geography, GeoLevel level) {
        Places result = new Places();
        for (Relation relation : this.events.values()) {
            Place place = geography.getPlace(relation.getAttributeValue("END_PLACE"), level);
            if (place == null) {
                place = new Place(level, String.valueOf(result.size()) + " ?");
            }
            if (result.size() != 0 && place.equals(result.get(String.valueOf(result.size() - 1)))) continue;
            result.put(String.valueOf(result.size()), place);
        }
        return result;
    }

    public void putInOrder(Relation event) {
        if (!this.events.containsValue(event)) {
            String orderString;
            String name = IndividualValuator.extractYear(event.getAttributeValue("DATE"));
            Integer year = null;
            Integer order = null;
            if (name == null) {
                name = "nd";
            } else {
                year = Integer.parseInt(name);
            }
            Relation previousEvent = this.events.get(new Ordinal(name, order, year));
            if (previousEvent != null) {
                int add = 2;
                previousEvent = this.events.get(new Ordinal(String.valueOf(name) + " " + add, order, year));
                while (previousEvent != null) {
                    previousEvent = this.events.get(new Ordinal(String.valueOf(name) + " " + ++add, order, year));
                }
                name = String.valueOf(name) + " " + add;
            }
            if ((orderString = SequenceWorker.order(event, this.ego)) != null && StringUtils.isNumeric((CharSequence)orderString)) {
                order = Integer.parseInt(orderString);
            }
            this.put(new Ordinal(name, order, year), event);
        }
    }

    public Map<Ordinal, Relation> getEvents() {
        return this.events;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String hashKey() {
        return String.valueOf(this.id);
    }

    @Override
    public int compareTo(Sequence sequence) {
        return Integer.valueOf(this.id).compareTo(sequence.id);
    }
}

