/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import fr.devinsy.util.StringList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.CircuitType;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationCensus;
import org.tip.puck.net.relations.RelationWorker;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.sequences.CorrelationMatrix;
import org.tip.puck.sequences.SequenceCensusCriteria;
import org.tip.puck.sequences.SequencesCensus;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class RelationReporter {
    public static Report reportTreeStructure(Segmentation segmentation, String relationModelName, Integer time, boolean reducedTrees, String pattern) throws PuckException {
        if (segmentation == null || relationModelName == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Cluster Structure " + relationModelName);
        Chronometer chrono = new Chronometer();
        result.setOrigin("Relation reporter");
        Relations relations = segmentation.getCurrentRelations().getByModelName(relationModelName).getByTime(time);
        for (Relation relation : relations.toListSortedByTypeId()) {
            result.outputs().appendln(relation + "\t" + relation.actors().size() + "\t" + RelationWorker.getLinkTrees(relation, reducedTrees, "GENDER", null) + "\t" + RelationWorker.getLinkTrees(relation, reducedTrees, "ID", null) + "\t" + RelationWorker.getLinkTrees(relation, reducedTrees, "KIN", pattern));
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportIndividualStatics(RelationCensus slices, StatisticsCriteria criteria) throws PuckException {
        if (criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Population Statics " + slices.relationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Relation reporter");
        for (PartitionCriteria partitionCriteria : criteria.getPartitionCriterias()) {
            if (StringUtils.isEmpty((CharSequence)partitionCriteria.getLabel())) continue;
            ArrayList<ReportChart> charts = new ArrayList<ReportChart>(20);
            ArrayList<ReportTable> tables = new ArrayList<ReportTable>(20);
            Integer[] integerArray = slices.times();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer time = integerArray[n2];
                if (partitionCriteria.getLabel().equals("AGE") || partitionCriteria.getLabel().equals("MATRISTATUS")) {
                    partitionCriteria.setLabelParameter("" + time);
                }
                Relations relations = slices.getRelations(time);
                String label = String.valueOf(slices.relationModelName()) + " " + time;
                Partition<Individual> partition = PartitionMaker.create(label, relations.getIndividuals(), relations, partitionCriteria);
                ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria());
                charts.add(chart);
                ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
                tables.add(table);
                ++n2;
            }
            int nr = Math.min(4, slices.size());
            int chartIndex = 0;
            while (chartIndex < charts.size()) {
                result.outputs().append((ReportChart)charts.get(chartIndex));
                if (chartIndex % nr == nr - 1) {
                    result.outputs().appendln();
                }
                ++chartIndex;
            }
            for (ReportTable table : tables) {
                result.outputs().appendln(table);
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportIndividualDynamics(RelationCensus slices, StatisticsCriteria criteria) throws PuckException {
        if (slices == null || criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Population Dynamics " + slices.relationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Space reporter");
        Integer[] times = slices.times();
        ArrayList<ReportChart> charts = new ArrayList<ReportChart>(20);
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>(20);
        int i = 0;
        while (i < times.length - 1) {
            Object destination2;
            int startTime = times[i];
            int endTime = times[i + 1];
            Relations totalStartSpace = slices.getAllRelations(startTime);
            Relations totalEndSpace = slices.getAllRelations(endTime);
            Relations filteredStartSpace = slices.getRelations(startTime);
            Relations filteredEndSpace = slices.getRelations(endTime);
            Partition<Individual> partition = new Partition<Individual>();
            partition.setLabel(String.valueOf(slices.relationModelName()) + " " + startTime + "-" + endTime);
            PartitionCriteria partitionCriteria = new PartitionCriteria();
            partitionCriteria.setLabel(partition.getLabel());
            Individuals totalStartPopulation = totalStartSpace.getIndividuals();
            Individuals totalEndPopulation = totalEndSpace.getIndividuals();
            Individuals filteredStartPopulation = filteredStartSpace.getIndividuals();
            Individuals filteredEndPopulation = filteredEndSpace.getIndividuals();
            Partition<Individual> destinations = new Partition<Individual>();
            destinations.setLabel("Destinations " + startTime + "/" + endTime);
            for (Individual individual : filteredStartSpace.getIndividuals().toSortedList()) {
                if (IndividualValuator.lifeStatusAtYear(individual, endTime).equals("DEAD")) {
                    partition.put(individual, new Value("DIED"));
                    continue;
                }
                if (!totalEndPopulation.contains(individual)) {
                    partition.put(individual, new Value("UNKNOWN DESTINATION"));
                    continue;
                }
                if (!filteredEndPopulation.contains(individual)) {
                    partition.put(individual, new Value("LEFT"));
                    for (Object destination2 : totalEndSpace.getByIndividual(individual)) {
                        destinations.put(individual, RelationValuator.get((Relation)destination2, "PLACE", (Object)criteria.getPlaceParameter()));
                    }
                    continue;
                }
                if (!filteredEndSpace.getByIndividual(individual).equals(filteredStartSpace.getByIndividual(individual))) {
                    partition.put(individual, new Value("INTERNAL CHANGE"));
                    continue;
                }
                partition.put(individual, new Value("UNCHANGED"));
            }
            Partition<Individual> origins = new Partition<Individual>();
            origins.setLabel("Origins " + startTime + "/" + endTime);
            destination2 = filteredEndSpace.getIndividuals().toSortedList().iterator();
            while (destination2.hasNext()) {
                Individual individual = (Individual)destination2.next();
                if (IndividualValuator.lifeStatusAtYear(individual, startTime).equals("UNBORN")) {
                    partition.put(individual, new Value("NEWBORN"));
                    continue;
                }
                if (!totalStartPopulation.contains(individual)) {
                    partition.put(individual, new Value("UNKNOWN ORIGIN"));
                    continue;
                }
                if (!filteredStartPopulation.contains(individual)) {
                    partition.put(individual, new Value("ENTERED"));
                    for (Relation origin : totalStartSpace.getByIndividual(individual)) {
                        origins.put(individual, RelationValuator.get(origin, "PLACE", (Object)criteria.getPlaceParameter()));
                    }
                    continue;
                }
                filteredStartSpace.getByIndividual(individual).equals(filteredEndSpace.getByIndividual(individual));
            }
            ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria());
            charts.add(chart);
            ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
            tables.add(table);
            ReportChart chartDestinations = StatisticsReporter.createPartitionChart(destinations, partitionCriteria, criteria.getSplitCriteria());
            charts.add(chartDestinations);
            ReportTable tableDestinations = ReportTable.transpose(chartDestinations.createReportTableWithSum());
            tables.add(tableDestinations);
            ReportChart chartOrigins = StatisticsReporter.createPartitionChart(origins, partitionCriteria, criteria.getSplitCriteria());
            charts.add(chartOrigins);
            ReportTable tableOrigins = ReportTable.transpose(chartOrigins.createReportTableWithSum());
            tables.add(tableOrigins);
            ++i;
        }
        int nr = Math.min(4, 2 * times.length);
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            result.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % nr == nr - 1) {
                result.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            result.outputs().appendln(table);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static List<Report> reportRelationCensus(Segmentation segmentation, String relationModelName, String egoRoleName, String alterRoleName, Integer[] times, String pattern) throws PuckException {
        if (segmentation == null || relationModelName == null || egoRoleName == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        ArrayList<Report> result = new ArrayList<Report>();
        CensusCriteria censusCriteria = new CensusCriteria();
        censusCriteria.setClosingRelation(relationModelName);
        censusCriteria.setClosingRelationEgoRole(egoRoleName);
        censusCriteria.setClosingRelationAlterRole(alterRoleName);
        censusCriteria.setCircuitType(CircuitType.RING);
        censusCriteria.setPattern(pattern);
        if (times == null) {
            Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
            report.setTitle("Relations " + egoRoleName + " " + alterRoleName);
            result.add(report);
        } else {
            int i = 0;
            while (i < times.length) {
                censusCriteria.setRelationTime(times[i]);
                Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
                report.setTitle("Relations " + egoRoleName + " " + alterRoleName + " " + times[i]);
                result.add(report);
                ++i;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Report reportDevelopmentCycles(RelationCensus slices, StatisticsCriteria criteria) throws PuckException {
        if (slices == null || criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Development Cycles " + slices.relationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Space reporter");
        SequenceCensusCriteria censusCriteria = new SequenceCensusCriteria();
        censusCriteria.setCensusType(SequenceCensusCriteria.CensusType.PARCOURS);
        censusCriteria.addNetworkTitle("Event Type Network");
        censusCriteria.getMainRelationAttributeTypes().add(SequenceCensusCriteria.RelationAttributeType.TREES);
        censusCriteria.getEventTypes().add(SequenceCensusCriteria.RelationAttributeType.TREES);
        for (SequenceCensusCriteria.RelationAttributeType relationAttributeType : censusCriteria.getMainRelationAttributeTypes()) {
            censusCriteria.getLabels().add("PROFILE_" + (Object)((Object)relationAttributeType));
            censusCriteria.getLabels().add("SUPPORT_" + (Object)((Object)relationAttributeType));
        }
        SequencesCensus census = new SequencesCensus(slices.getSequences(), censusCriteria);
        SequenceCensusCriteria.CensusType censusType = censusCriteria.getCensusType();
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report componentReport = new Report("Components");
        Report treeReport = new Report("Trees");
        ArrayList<Object> charts = new ArrayList<Object>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getLabels()) {
            void var17_20;
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            Object var17_21 = null;
            if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                NumberedValues values = census.getValues(label);
                Partition<Relation> partition = PartitionMaker.create(label, slices.getRelations(slices.times()[0]), values, partitionCriteria);
                PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                ReportChart reportChart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
                overallReport.outputs().append(String.valueOf(label) + "\t");
                String sum = "";
                if (label.startsWith("NR")) {
                    sum = String.valueOf(new Double(values.sum()).intValue());
                }
                overallReport.outputs().append(String.valueOf(MathUtils.round(values.average(), 2)) + "\t" + MathUtils.round(values.averagePositives(), 2) + "\t" + values.median() + "\t" + values.max() + "\t" + sum + "\t");
                overallReport.outputs().appendln();
            }
            if (var17_20 == null) continue;
            charts.add(var17_20);
            ReportTable table = ReportTable.transpose(var17_20.createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize(table));
        }
        overallReport.outputs().appendln();
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getLabels()) {
            detailReport.outputs().append("\t" + partitionLabel);
        }
        detailReport.outputs().appendln();
        for (Relation ego : slices.getRelations(slices.times()[0])) {
            if (censusType != SequenceCensusCriteria.CensusType.GENERAL && censusType != SequenceCensusCriteria.CensusType.PARCOURS) continue;
            detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego);
            for (String label : censusCriteria.getLabels()) {
                if (label.contains("SIMILARITY")) {
                    String[] keys;
                    Value value = (Value)census.getValues(label).get(ego.getId());
                    Map indiSimilaritiesMap = value.mapValue();
                    String[] stringArray = keys = new String[]{"PARENT", "CHILD", "SIBLING", "SPOUSE"};
                    int n = keys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        Double[] sim = (Double[])indiSimilaritiesMap.get(new Value(key));
                        if (sim != null) {
                            detailReport.outputs().append("\t" + MathUtils.round(sim[4], 2));
                        }
                        ++n2;
                    }
                    continue;
                }
                detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
            }
            detailReport.outputs().appendln();
        }
        if (censusType == SequenceCensusCriteria.CensusType.PARCOURS) {
            for (SequenceCensusCriteria.RelationAttributeType relationAttributeType : censusCriteria.getMainRelationAttributeTypes()) {
                CorrelationMatrix subSequenceMatrix;
                if (censusCriteria.getNetworkTitles().contains("Event Type Network")) {
                    CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix(relationAttributeType.toString());
                    if (eventSequenceMatrix != null) {
                        for (ReportChart reportChart : eventSequenceMatrix.getCharts()) {
                            charts.add(reportChart);
                        }
                        tables.add(eventSequenceMatrix.getTable("Event Type Sequences"));
                    }
                    overallReport.outputs().appendln();
                    overallReport.outputs().appendln("Sequence Network Statistics " + (Object)((Object)relationAttributeType));
                    overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
                    Gender[] genderArray = Gender.values();
                    int indiSimilaritiesMap = genderArray.length;
                    int value = 0;
                    while (value < indiSimilaritiesMap) {
                        Gender gender = genderArray[value];
                        GraphProfile<Cluster<String>> profile = eventSequenceMatrix.getProfile(gender);
                        String centralReferents = "";
                        for (Cluster cluster : profile.getCentralReferents()) {
                            centralReferents = String.valueOf(centralReferents) + cluster.getValue() + " ";
                        }
                        double d = profile.getMaxBetweenness();
                        double density = profile.density();
                        double endo = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.NORMALIZED), 2);
                        double endoExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.DIVERGENCE_NORMALIZED), 2);
                        double conc = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.SIMPLE), 2);
                        double concExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.DIVERGENCE), 2);
                        double sym = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.SIMPLE), 2);
                        double symExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.DIVERGENCE), 2);
                        overallReport.outputs().appendln((Object)((Object)gender) + "\t" + density + "\t" + endo + "\t" + endoExp + "\t" + conc + "\t" + concExp + "\t" + sym + "\t" + symExp + "\t" + centralReferents + "(" + d + ") betweenness centrality");
                        ++value;
                    }
                    overallReport.outputs().appendln();
                }
                if (!censusCriteria.getNetworkTitles().contains("Sequence Type Network") || (subSequenceMatrix = census.getSubSequenceMatrix(relationAttributeType.toString())) == null) continue;
                charts.add(subSequenceMatrix.getRamificationChart());
            }
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        if (censusType == SequenceCensusCriteria.CensusType.EGONETWORKS || censusType == SequenceCensusCriteria.CensusType.PARCOURSNETWORKS) {
            result.outputs().append(componentReport);
        }
        if (censusType == SequenceCensusCriteria.CensusType.PARCOURS) {
            result.outputs().append(treeReport);
        }
        Map<String, StringList> pajekBuffers = census.getPajekBuffers();
        for (String title : pajekBuffers.keySet()) {
            StringList stringList = pajekBuffers.get(title);
            if (stringList.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File("Test"), "-" + title), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(stringList.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

