/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.bar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.bar.BARTXTFile;
import org.tip.puck.io.xls.XLSBufferedReader;
import org.tip.puck.io.xls.XLSWriter;
import org.tip.puck.net.Net;

public class BARXLSFile {
    public static final int MAX_LINE_SIZE = 1024;
    private static final Logger logger = LoggerFactory.getLogger(BARXLSFile.class);

    public static Net load(File file) throws PuckException {
        Net result;
        XLSBufferedReader in = null;
        try {
            try {
                in = new XLSBufferedReader(file);
                result = BARTXTFile.read(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                exception.printStackTrace();
                throw PuckExceptions.UNSUPPORTED_ENCODING.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                exception.printStackTrace();
                throw PuckExceptions.FILE_NOT_FOUND.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
                throw PuckExceptions.IO_ERROR.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new XLSWriter(file, "Kinship Relations", "Attributs"));
                BARTXTFile.write(out, source);
            }
            catch (IOException exception) {
                exception.printStackTrace();
                throw PuckExceptions.IO_ERROR.create(exception, "Opening file [" + file + "].", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
    }

    public static void save(File file, Net source, ResourceBundle bundle) throws PuckException {
    }

    protected static enum Status {
        MANDATORY,
        OPTIONAL;

    }
}

