/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.List;
import org.tip.puck.geo.GeoLevel;

public class Place {
    String name;
    GeoLevel level;
    Place sup;
    Coordinate coordinate;

    public Place(String name) {
        this.name = name;
        this.coordinate = null;
    }

    public Place(GeoLevel level, String name) {
        this(name);
        this.level = level;
    }

    public Place(String name, Coordinate coord) {
        this(name);
        this.coordinate = coord;
    }

    public Place getSup() {
        return this.sup;
    }

    public void setSup(Place sup) {
        this.sup = sup;
    }

    public Place getSup(List<String> placenames) {
        Place result = this;
        while (result != null && !placenames.contains(result.getShortName())) {
            result = result.getSup();
        }
        return result;
    }

    public Place atLevel(GeoLevel level) {
        Place result = this;
        while (result != null && result.level != level) {
            result = result.getSup();
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        String result = null;
        if (this.name != null) {
            result = this.name.split("\\/")[0].trim();
        }
        return result;
    }

    public GeoLevel getLevel() {
        return this.level;
    }

    public void setLevel(GeoLevel level) {
        this.level = level;
    }

    public String toString() {
        return this.getId();
    }

    public int compareByLevel(Place place) {
        int result = this.level.compareTo(place.level);
        return result;
    }

    public String getId() {
        String result = this.sup == null ? this.name : String.valueOf(this.name) + " / " + this.sup.name;
        return result;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public void setCoordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
    }
}

