/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo;

import java.util.ArrayList;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.geotools.feature.DefaultFeatureCollection;
import org.tip.puck.geo.io.GeoNamesWebService;
import org.tip.puck.graphs.Graph;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.views.geo.ConfigGeocodingDialog;
import org.tip.puckgui.views.geo.MapPanel;

public class Geocode
extends SwingWorker<ArrayList<DefaultFeatureCollection>, Object> {
    ArrayList<DefaultFeatureCollection> collectionfeaturesReadyToBeDisplayed;
    ConfigGeocodingDialog mainDialog;
    JProgressBar progressBar;
    String typeOfGeocodingSource;
    GroupNetGUI parentGUI;

    public Geocode(ConfigGeocodingDialog mainDialog, JProgressBar progressBar, String typeOfGeocodingSource, GroupNetGUI parentGUI) {
        this.mainDialog = mainDialog;
        this.progressBar = progressBar;
        this.typeOfGeocodingSource = typeOfGeocodingSource;
        this.parentGUI = parentGUI;
    }

    public ArrayList<DefaultFeatureCollection> buildPointAndLinesGeometry(JProgressBar progressBar, String typeOfGeocodingSource, Graph<?> graph) {
        if (typeOfGeocodingSource.compareTo("geonames") == 0) {
            this.progressBar.setString("Processing ... ");
            GeoNamesWebService ws = new GeoNamesWebService(this.progressBar);
            this.collectionfeaturesReadyToBeDisplayed = ws.getCoordForNodesPlaces(graph);
        }
        if (typeOfGeocodingSource.compareTo("personnalSources") == 0) {
            System.out.println("TODO !");
        }
        if (typeOfGeocodingSource.compareTo("geonamesFile") == 0) {
            System.out.println("TODO !");
        }
        return this.collectionfeaturesReadyToBeDisplayed;
    }

    @Override
    protected ArrayList<DefaultFeatureCollection> doInBackground() throws Exception {
        if (this.typeOfGeocodingSource.compareTo("geonames") == 0) {
            GeoNamesWebService ws = new GeoNamesWebService(this.progressBar);
            this.collectionfeaturesReadyToBeDisplayed = ws.getCoordForNodesPlaces(this.parentGUI.getGroupNet());
        }
        if (this.typeOfGeocodingSource.compareTo("personnalSources") == 0) {
            System.out.println("TODO !");
        }
        if (this.typeOfGeocodingSource.compareTo("geonamesFile") == 0) {
            System.out.println("TODO !");
        }
        return this.collectionfeaturesReadyToBeDisplayed;
    }

    @Override
    protected void done() {
        try {
            this.mainDialog.dispose();
            MapPanel geographyMap = new MapPanel();
            geographyMap.diplayCollectionsPointsAndLines(this.collectionfeaturesReadyToBeDisplayed);
            this.parentGUI.addTab("Geography", geographyMap);
            System.out.println("done");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

