/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.generators;

import org.tip.puck.generators.PGraph;
import org.tip.puck.net.Net;
import org.tip.puck.report.Report;
import org.tip.puck.util.Chronometer;

public class GeneratorsReporter {
    public static Report reportShufflePGraph(PGraph pgraph, Net sourceNet, int edgePermutations, int maxGenerationalDistance, int minShufflePercentage, int minStableIterations) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Suffle P-Graph.");
        result.setOrigin("Generators reporter");
        result.setTarget(sourceNet.getLabel());
        result.inputs().add("Edge permutations per step", edgePermutations);
        result.inputs().add("Maximum generational distance", maxGenerationalDistance);
        result.inputs().add("Minimum shuffle percentage (stop condition)", minShufflePercentage);
        result.inputs().add("Minimum stable iterations (stop condition)", minStableIterations);
        result.outputs().append(pgraph.toString());
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

