/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.alliancenets;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.tip.puck.alliancenets.Alliance;
import org.tip.puck.alliancenets.AllianceNetFile;
import org.tip.puck.alliancenets.Group;
import org.tip.puck.util.RandomGenerator;

public class AllianceNet
implements Cloneable {
    private static int CURID = 0;
    private double minPRIn;
    private double minPROut;
    private double maxPRIn;
    private double maxPROut;
    protected Vector<Group> groups = new Vector();
    protected Vector<Alliance> alliances = new Vector();
    protected Map<Integer, Group> nodeMap = new HashMap<Integer, Group>();
    private int nodeCount = 0;
    private int edgeCount = 0;
    private boolean selfEdges = false;

    public AllianceNet() {
    }

    public AllianceNet(boolean selfEdges) {
        this();
        this.selfEdges = selfEdges;
    }

    public AllianceNet clone() {
        AllianceNet clonedNet = new AllianceNet();
        for (Group group : this.groups) {
            clonedNet.addNode(group.clone());
        }
        for (Alliance alliance : this.alliances) {
            Group orig = alliance.getOrigin();
            Group targ = alliance.getTarget();
            long timestamp = alliance.getTimestamp();
            double weight = alliance.getWeight();
            Group corig = clonedNet.getNodeById(orig.getId());
            Group ctarg = clonedNet.getNodeById(targ.getId());
            clonedNet.addEdge(corig, ctarg, weight, timestamp);
        }
        return clonedNet;
    }

    public AllianceNet cloneFlagged() {
        AllianceNet clonedNet = new AllianceNet();
        for (Group group : this.groups) {
            if (!group.isFlag()) continue;
            clonedNet.addNode(group.clone());
        }
        for (Alliance alliance : this.alliances) {
            Group orig = alliance.getOrigin();
            Group targ = alliance.getTarget();
            if (!orig.isFlag() || !targ.isFlag()) continue;
            long timestamp = alliance.getTimestamp();
            double weight = alliance.getWeight();
            Group corig = clonedNet.getNodeById(orig.getId());
            Group ctarg = clonedNet.getNodeById(targ.getId());
            clonedNet.addEdge(corig, ctarg, weight, timestamp);
        }
        return clonedNet;
    }

    public static AllianceNet load(String filePath) {
        return new AllianceNetFile().load(filePath);
    }

    public void save(String filePath) {
        new AllianceNetFile().save(this, filePath);
    }

    public Group addNode(Group group) {
        ++this.nodeCount;
        this.groups.add(group);
        this.nodeMap.put(group.getId(), group);
        return group;
    }

    public Group addNode() {
        Group group = new Group(CURID++);
        this.addNode(group);
        return group;
    }

    public Group addNodeWithId(int nid) {
        if (nid >= CURID) {
            CURID = nid + 1;
        }
        Group group = new Group(nid);
        this.addNode(group);
        return group;
    }

    public Group getNodeById(int id) {
        return this.nodeMap.get(id);
    }

    public boolean addEdge(Group origin, Group target, double weight, long timestamp) {
        if (!this.selfEdges && origin == target) {
            return false;
        }
        if (this.edgeExists(origin, target)) {
            return false;
        }
        Alliance alliance = new Alliance(origin, target, weight, timestamp);
        this.alliances.add(alliance);
        origin.addOutEdge(alliance);
        target.addInEdge(alliance);
        ++this.edgeCount;
        return true;
    }

    public boolean addEdge(Group origin, Group target) {
        return this.addEdge(origin, target, 0.0, 0L);
    }

    public boolean addEdge(Group origin, Group target, double weight) {
        return this.addEdge(origin, target, weight, 0L);
    }

    public boolean addEdge(Group origin, Group target, long timestamp) {
        return this.addEdge(origin, target, 0.0, timestamp);
    }

    public boolean edgeExists(Group origin, Group target) {
        for (Alliance alliance : origin.getOutEdges()) {
            if (alliance.getTarget() != target) continue;
            return true;
        }
        return false;
    }

    public Alliance getEdge(Group origin, Group target) {
        for (Alliance alliance : origin.getOutEdges()) {
            if (alliance.getTarget() != target) continue;
            return alliance;
        }
        return null;
    }

    public Alliance getInverseEdge(Alliance alliance) {
        return this.getEdge(alliance.getTarget(), alliance.getOrigin());
    }

    public void removeEdge(Alliance alliance) {
        alliance.getOrigin().removeOutput(alliance);
        alliance.getTarget().removeInput(alliance);
        this.alliances.remove(alliance);
        --this.edgeCount;
    }

    public void removeNode(Group group) {
        LinkedList<Alliance> remEdges = new LinkedList<Alliance>(group.getInEdges());
        for (Alliance e : remEdges) {
            this.removeEdge(e);
        }
        remEdges = new LinkedList<Alliance>(group.getOutEdges());
        for (Alliance e : remEdges) {
            this.removeEdge(e);
        }
        this.groups.remove(group);
        this.nodeMap.remove(group.getId());
        --this.nodeCount;
    }

    public void removeNonFlaggedNodes() {
        LinkedList<Group> remNodes = new LinkedList<Group>();
        for (Group n : this.groups) {
            if (n.isFlag()) continue;
            remNodes.add(n);
        }
        for (Group n : remNodes) {
            this.removeNode(n);
        }
    }

    public Group getRandomNode() {
        int pos = RandomGenerator.instance().random.nextInt(this.nodeCount);
        return this.groups.get(pos);
    }

    public void computePageranks() {
        int maxIter = 10;
        double drag = 0.999;
        for (Group group : this.groups) {
            group.setPrInLast(1.0);
            group.setPrOutLast(1.0);
        }
        int i = 0;
        while (i < maxIter) {
            double accPRIn = 0.0;
            double accPROut = 0.0;
            for (Group group : this.groups) {
                group.setPrIn(0.0);
                for (Alliance origin : group.getInEdges()) {
                    group.setPrIn(group.getPrIn() + origin.getOrigin().getPrInLast() / (double)origin.getOrigin().getOutDegree());
                }
                group.setPrIn(group.getPrIn() * drag);
                group.setPrIn(group.getPrIn() + (1.0 - drag) / (double)this.nodeCount);
                accPRIn += group.getPrIn();
                group.setPrOut(0.0);
                for (Alliance target : group.getOutEdges()) {
                    group.setPrOut(group.getPrOut() + target.getTarget().getPrOutLast() / (double)target.getTarget().getInDegree());
                }
                group.setPrOut(group.getPrOut() * drag);
                group.setPrOut(group.getPrOut() + (1.0 - drag) / (double)this.nodeCount);
                accPROut += group.getPrOut();
            }
            for (Group group : this.groups) {
                group.setPrIn(group.getPrIn() / accPRIn);
                group.setPrOut(group.getPrOut() / accPROut);
                group.setPrInLast(group.getPrIn());
                group.setPrOutLast(group.getPrOut());
            }
            ++i;
        }
        double basePR = 1.0 / (double)this.nodeCount;
        for (Group group : this.groups) {
            group.setPrIn(group.getPrIn() / basePR);
            group.setPrOut(group.getPrOut() / basePR);
        }
        for (Group group : this.groups) {
            group.setPrIn(Math.log(group.getPrIn()));
            group.setPrOut(Math.log(group.getPrOut()));
        }
        this.minPRIn = 0.0;
        this.minPROut = 0.0;
        this.maxPRIn = 0.0;
        this.maxPROut = 0.0;
        boolean first = true;
        for (Group group : this.groups) {
            if (!new Double(group.getPrIn()).isInfinite() && (first || group.getPrIn() < this.minPRIn)) {
                this.minPRIn = group.getPrIn();
            }
            if (!new Double(group.getPrOut()).isInfinite() && (first || group.getPrOut() < this.minPROut)) {
                this.minPROut = group.getPrOut();
            }
            if (!new Double(group.getPrIn()).isInfinite() && (first || group.getPrIn() > this.maxPRIn)) {
                this.maxPRIn = group.getPrIn();
            }
            if (!new Double(group.getPrOut()).isInfinite() && (first || group.getPrOut() > this.maxPROut)) {
                this.maxPROut = group.getPrOut();
            }
            first = false;
        }
    }

    public void writePageranks(String filePath) {
        try {
            FileWriter outFile = new FileWriter(filePath);
            PrintWriter out = new PrintWriter(outFile);
            out.println("id, pr_in, pr_out, in_degree, out_degree");
            for (Group group : this.groups) {
                out.println(String.format("%d,%.10f,%.10f,%d,%d\n", group.getId(), group.getPrIn(), group.getPrOut(), group.getInDegree(), group.getOutDegree()));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printNetInfo() {
        System.out.println("node number: " + this.nodeCount);
        System.out.println("edge number: " + this.edgeCount);
        System.out.println(String.format("log(pr_in): [%f, %f]\n", this.minPRIn, this.maxPRIn));
        System.out.println(String.format("log(pr_out): [%f, %f]\n", this.minPROut, this.maxPROut));
    }

    public int[] inDegSeq() {
        int[] seq = new int[this.nodeCount];
        int i = 0;
        for (Group curnode : this.groups) {
            seq[i] = curnode.getInDegree();
            ++i;
        }
        return seq;
    }

    public int[] outDegSeq() {
        int[] seq = new int[this.nodeCount];
        int i = 0;
        for (Group curnode : this.groups) {
            seq[i] = curnode.getOutDegree();
            ++i;
        }
        return seq;
    }

    void genDegreeSeq(AllianceNet refNet) {
        int[] inDegSeq = refNet.inDegSeq();
        int[] outDegSeq = refNet.outDegSeq();
        int totalDegree = refNet.edgeCount;
        Group[] newNodes = new Group[refNet.nodeCount];
        int i = 0;
        while (i < refNet.nodeCount) {
            newNodes[i] = this.addNode();
            ++i;
        }
        int stable = 0;
        while (stable < 1000) {
            int origPos = RandomGenerator.instance().random.nextInt(totalDegree);
            int targPos = RandomGenerator.instance().random.nextInt(totalDegree);
            int curpos = 0;
            int origIndex = -1;
            while (curpos <= origPos) {
                curpos += outDegSeq[++origIndex];
            }
            curpos = 0;
            int targIndex = -1;
            while (curpos <= targPos) {
                curpos += inDegSeq[++targIndex];
            }
            if (this.addEdge(newNodes[origIndex], newNodes[targIndex], 0L)) {
                int n = origIndex;
                outDegSeq[n] = outDegSeq[n] - 1;
                int n2 = targIndex;
                inDegSeq[n2] = inDegSeq[n2] - 1;
                --totalDegree;
                stable = 0;
            }
            ++stable;
        }
    }

    double getMinPRIn() {
        return this.minPRIn;
    }

    double getMinPROut() {
        return this.minPROut;
    }

    double getMaxPRIn() {
        return this.maxPRIn;
    }

    double getMaxPROut() {
        return this.maxPROut;
    }

    void printPRInfo() {
        System.out.println("Input PR > min: " + this.getMinPRIn() + "; max: " + this.getMaxPRIn());
        System.out.println("Output PR > min: " + this.getMinPROut() + "; max: " + this.getMaxPROut());
    }

    public Vector<Group> getNodes() {
        return this.groups;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    void setNodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
    }

    public int getEdgeCount() {
        return this.edgeCount;
    }

    void setEdgeCount(int edgeCount) {
        this.edgeCount = edgeCount;
    }

    public Vector<Alliance> getEdges() {
        return this.alliances;
    }

    public String toString() {
        String str = "node count: " + this.nodeCount + "\n";
        str = String.valueOf(str) + "edge count: " + this.edgeCount + "\n";
        return str;
    }

    public void printDegDistInfo() {
        int i;
        int[] inDegSeq = this.inDegSeq();
        int[] outDegSeq = this.outDegSeq();
        int[] inDegrees = new int[10];
        int[] outDegrees = new int[10];
        int i2 = 0;
        while (i2 < 10) {
            inDegrees[i2] = 0;
            outDegrees[i2] = 0;
            ++i2;
        }
        int maxIn = 0;
        int[] nArray = inDegSeq;
        int n = inDegSeq.length;
        int n2 = 0;
        while (n2 < n) {
            int i3 = nArray[n2];
            if (i3 > maxIn) {
                maxIn = i3;
            }
            if (i3 < 10) {
                int n3 = i3;
                inDegrees[n3] = inDegrees[n3] + 1;
            }
            ++n2;
        }
        int maxOut = 0;
        int[] nArray2 = outDegSeq;
        int n4 = outDegSeq.length;
        n = 0;
        while (n < n4) {
            i = nArray2[n];
            if (i > maxOut) {
                maxOut = i;
            }
            if (i < 10) {
                int n5 = i;
                outDegrees[n5] = outDegrees[n5] + 1;
            }
            ++n;
        }
        System.out.println("max in: " + maxIn + "; max out: " + maxOut);
        System.out.println(">>> in degrees");
        i = 0;
        while (i < 10) {
            System.out.print(i + ": " + inDegrees[i] + " ");
            ++i;
        }
        System.out.println("\n>>> out degrees");
        i = 0;
        while (i < 10) {
            System.out.print(i + ": " + outDegrees[i] + " ");
            ++i;
        }
        System.out.println("\n");
    }

    public void clearFlags() {
        for (Group group : this.groups) {
            group.setFlag(false);
        }
    }

    public Group firstNode() {
        Group group = null;
        try {
            group = this.groups.firstElement();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return group;
    }
}

